/*-----------------------------------------------------------------------------
* EcSlaveInfo.h
* Copyright                acontis technologies GmbH, Ravensburg, Germany
* Response                 Holger Oelhaf
* Description
*---------------------------------------------------------------------------*/

#ifndef INC_ECSLAVEINFO
#define INC_ECSLAVEINFO 1

#ifndef INC_ECDEMOPARMS_H
#include "EcDemoParms.h"
#endif

/*-TYPEDEFS------------------------------------------------------------------*/
typedef enum _T_eEtherCAT_Vendor
{
    ecvendor_etg                                = 0x00000001,
    ecvendor_beckhoff                           = 0x00000002,
    ecvendor_scuola_superiore_s_anna            = 0x00000003,
    ecvendor_ixxat                              = 0x00000004,
    ecvendor_vector_informatik                  = 0x00000005,
    ecvendor_knestel                            = 0x00000006,
	ecvendor_janz_tec                           = 0x00000007,
	ecvendor_a_and_c_shenyang_university        = 0x00000009,
    ecvendor_cmz_sistemi                        = 0x0000000a,
	ecvendor_jsl								= 0x0000000b,
	ecvendor_comemso 							= 0x0000000c,
    ecvendor_softing                            = 0x0000000d,
    ecvendor_microcontrol                       = 0x0000000e,
    ecvendor_pollmeier                          = 0x0000000f,
    ecvendor_beihang_university                 = 0x00000010,
	ecvendor_gkg_precision_machine 				= 0x00000011,
	ecvendor_inatech 							= 0x00000012,
    ecvendor_kuebler                            = 0x00000013,
    ecvendor_keb                                = 0x00000014,
    ecvendor_ajinextek                          = 0x00000015,
    ecvendor_lti                                = 0x00000016,
    ecvendor_esd_electronic_design              = 0x00000017,
	ecvendor_m2i								= 0x00000018,
	ecvendor_nsd 								= 0x00000019,
	ecvendor_shanghai_ecat_science 				= 0x0000001a,
    ecvendor_hms_industrial_networks            = 0x0000001b,
    ecvendor_epis_automation                    = 0x0000001c,
	ecvendor_shanghai_microport_medical 		= 0x0000001e,
    ecvendor_festo                              = 0x0000001d,
	ecvendor_dst_robot 							= 0x00000020,
    ecvendor_wago                               = 0x00000021,
	ecvendor_wuhan_farley 						= 0x00000022,
	ecvendor_acti 								= 0x00000023,
    ecvendor_boschrexroth                       = 0x00000024,
	ecvendor_hongke							    = 0x00000026,
	ecvendor_selcom_elettronica 				= 0x00000027,
    ecvendor_moog                               = 0x00000028,
	ecvendor_intec_motion_systems 				= 0x00000029,
	ecvendor_highyag_lasertechnologie 			= 0x0000002a,
	ecvendor_guangzhou_kossi 					= 0x0000002f,
    ecvendor_port                               = 0x00000034,
    ecvendor_buerkert_werke                     = 0x00000039,
	ecvendor_adtec_plasma					    = 0x0000003a,
    ecvendor_lenze                              = 0x0000003B,
	ecvendor_shanghai_3crobot 					= 0x0000003c,
	ecvendor_tianjin_fuyun_tianyi 				= 0x0000003d,
	ecvendor_mts_sensor 						= 0x00000040,
    ecvendor_tigris_electronic                  = 0x00000042,
    ecvendor_hilscher                           = 0x00000044,
	ecvendor_industrial_software 				= 0x00000049,
	ecvendor_ever 								= 0x0000004b,
    ecvendor_murrelektronik                     = 0x0000004F,
    ecvendor_knorr_bremse                       = 0x00000051,
	ecvendor_beijing_jingwei 					= 0x00000052,
    ecvendor_komax                              = 0x00000057,
    ecvendor_sew_eurodrive                      = 0x00000059,
	ecvendor_schleicher 						= 0x0000005d,
	ecvendor_incaa_computers                    = 0x00000060,
    ecvendor_bachmann_electronic                = 0x00000062,
    ecvendor_rofin_sinar                        = 0x00000066,
    ecvendor_fagor_automation                   = 0x00000068,
    ecvendor_danaher                            = 0x0000006A,
    ecvendor_kollmorgen                         = 0xE000006A,
    ecvendor_woodward_seg                       = 0x0000006b,
    ecvendor_bernecker_rainer_ie                = 0x0000006c,
    ecvendor_ina_oriental_motor                 = 0x00000072,
    ecvendor_slc_sautter_lift                   = 0x00000077,
    ecvendor_sibonac_laser                      = 0x0000007a,
    ecvendor_tuev_sued_rail                     = 0x0000007b,
    ecvendor_infranor_electronics               = 0x00000082,
    ecvendor_omron                              = 0x00000083,
    ecvendor_phoenix_contact                    = 0x00000084,
    ecvendor_thinkvo                            = 0x00000088,
    ecvendor_system                             = 0x0000008a,
	ecvendor_vacon_plc                          = 0x00000090,
    ecvendor_gefran                             = 0x00000093,
	ecvendor_shenzhen 							= 0x00000099,
    ecvendor_elmo_motion                        = 0x0000009a,
	ecvendor_hans_turck                         = 0x0000009c,
	ecvendor_konsept_elektronik                 = 0x0000009f,
    ecvendor_sontheim_industrie_elektronik      = 0x000000a0,
	ecvendor_horiba_stec                        = 0x000000a2,
    ecvendor_hirschmann_automation              = 0x000000a5,
	ecvendor_wieland                            = 0x000000a7,
	ecvendor_bejing_ae_precision_machinery      = 0x000000aa,
    ecvendor_copley                             = 0x000000AB,
    ecvendor_pepperl_fuchs                      = 0x000000ad,
    ecvendor_johannes_huebner                   = 0x000000af,
	ecvendor_bristol 							= 0x000000b1,
	ecvendor_jetter 							= 0x000000b3,
    ecvendor_abb_oy_drives                      = 0x000000b7,
    ecvendor_stoeber                            = 0x000000b9,
	ecvendor_aec                                = 0x000000bc,
    ecvendor_advanced_motion_controls           = 0x000000bd,
    ecvendor_bloom_energy                       = 0x000000be,
    ecvendor_technofusion                       = 0x000000c0,
    ecvendor_comdel                             = 0x000000c5,
    ecvendor_densan                             = 0x000000cc,
    ecvendor_messung_systems                    = 0x000000ce,
    ecvendor_bonfiglioli_vectron                = 0x000000d5,
    ecvendor_phase_motion_control               = 0x000000d9,
	ecvendor_diener_automation 					= 0x000000da,
	ecvendor_plating_electronic				    = 0x000000e2,
    ecvendor_metronix                           = 0x000000e4,
    ecvendor_ascon                              = 0x000000e9,
	ecvendor_esab_atas                          = 0x000000ea,
	ecvendor_elektrobit_automotive              = 0x000000eb,
	ecvendor_baumer_ivo                         = 0x000000ec,
	ecvendor_ed_elettronica                     = 0x000000ed,
	ecvendor_mclaren_group                      = 0x000000f1,
	ecvendor_guangdong_university               = 0x000000f2,
	ecvendor_atos_spa                           = 0x000000f4,
	ecvendor_giant_magellan_telescope           = 0x000000f5,
    ecvendor_controltechniques                  = 0x000000F9,
    ecvendor_maxon_motor                        = 0x000000FB,
	ecvendor_yacoub_automation                  = 0x000000fc,
	ecvendor_precitec                           = 0x000000fe,
	ecvendor_south_china_university             = 0x000000ff,
	ecvendor_easydur                            = 0x00000100,
	ecvendor_isac                               = 0x00000101,
	ecvendor_lmd                                = 0x00000104,
    ecvendor_keba                               = 0x00000105,
    ecvendor_wittenstein                        = 0x0000010a,
    ecvendor_twk_elektronik                     = 0x0000010d,
	ecvendor_wittenstein_motion                 = 0x0000010b,
    ecvendor_psa_elettronica                    = 0x0000010f,
	ecvendor_heitec                             = 0x00000111,
    ecvendor_smc                                = 0x00000114,
	ecvendor_eckelmann                          = 0x00000116,
    ecvendor_jvl_industri_elektronik            = 0x00000117,
	ecvendor_atesteo                            = 0x0000011c,
    ecvendor_hottinger_baldwin                  = 0x0000011d,
    ecvendor_leuze_electronic                   = 0x00000121,
	ecvendor_weg                                = 0x00000123,
    ecvendor_jumo                               = 0x00000126,
    ecvendor_hsd                                = 0x00000129,
	ecvendor_digital_electronics                = 0x0000012b,
    ecvendor_lika_electronic                    = 0x0000012e,
    ecvendor_csm                                = 0x0000012f,
	ecvendor_duometric                          = 0x00000135,
	ecvendor_fenwal_controls                    = 0x00000137,
	ecvendor_scaime                             = 0x00000142,
	ecvendor_tecnologix                         = 0x00000144,
    ecvendor_lpkf_motion_control                = 0x00000146,
	ecvendor_fritz_faulhaber                    = 0x00000147,
	ecvendor_fraunhofer_institut                = 0x00000149,
    ecvendor_imc_messysteme                     = 0x0000014a,
	ecvendor_tmg                                = 0x0000014f,
	ecvendor_ferrocontrol                       = 0x00000152,
	ecvendor_bluechips                          = 0x00000155,
    ecvendor_baumueller                         = 0x0000015A,
	ecvendor_engel                              = 0x0000015b,
	ecvendor_seltek                             = 0x00000160,
	ecvendor_aerolas                            = 0x00000163,
	ecvendor_metso                              = 0x00000166,
	ecvendor_amp_and_moons                      = 0x00000168,
	ecvendor_comsoft                            = 0x0000016d,
	ecvendor_prima                              = 0x00000171,
	ecvendor_fraunhofer_ipk                     = 0x00000172,
	ecvendor_mit_university                     = 0x00000175,
	ecvendor_foshan_korter                      = 0x00000178,
    ecvendor_pneumax                            = 0x0000017a,
	ecvendor_rta                                = 0x0000017f,
	ecvendor_fev                                = 0x00000181,
	ecvendor_bei_sensors                        = 0x00000184,
	ecvendor_zhejiang_universit                 = 0x00000186,
	ecvendor_asa_rt                             = 0x0000018a,
    ecvendor_promess                            = 0x00000190,
	ecvendor_promess_incorporated               = 0x00000191,
	ecvendor_matsusada                          = 0x00000192,
	ecvendor_leine_linde                        = 0x00000194,
	ecvendor_siko                               = 0x00000195,
    ecvendor_deutschmann                        = 0x0000019d,
    ecvendor_golden                             = 0x0000019e,
    ecvendor_brunner_elektronik                 = 0x000001a1,
	ecvendor_heckner                            = 0x000001a2,
    ecvendor_technosoft                         = 0x000001a3,
	ecvendor_kongsberg                          = 0x000001a4,
	ecvendor_reo                                = 0x000001a6,
	ecvendor_abb                                = 0x000001b0,
	ecvendor_aventics                           = 0x000001b2,
    ecvendor_peyer_engineering                  = 0x000001b4,
    ecvendor_robox                              = 0x000001B5,
    ecvendor_parker                             = 0xE00001B5,
	ecvendor_pmb                                = 0x000001b8,
    ecvendor_sanyo_denki                        = 0x000001b9,
	ecvendor_eurotherm                          = 0x000001bc,
	ecvendor_kobe_steel                         = 0x000001c0,
	ecvendor_regatron                           = 0x000001c4,
	ecvendor_eaton                              = 0x000001c7,
    ecvendor_delta_electronics                  = 0x000001dd,
	ecvendor_xeikon                             = 0x000001df,
	ecvendor_numatics                           = 0x000001e1,
    ecvendor_amk                                = 0x000001eb,
	ecvendor_robatech                           = 0x000001f4,
    ecvendor_national_instruments               = 0x000001F9,
    ecvendor_fernsteuergeraete_kurt_oelsch      = 0x000001fc,
    ecvendor_idam                               = 0x000001FD,
    ecvendor_prueftechnik_ndt                   = 0x000001fe,
	ecvendor_zhejiang_qixing                    = 0x000001ff,
    ecvendor_baumer_th                          = 0x00000204,
	ecvendor_tde_macno                          = 0x00000205,
    ecvendor_esitron_electronic                 = 0x00000207,
	ecvendor_itoh_denki                         = 0x0000020c,
	ecvendor_real_time                          = 0x00000219,
	ecvendor_wachendorff                        = 0x0000021f,
    ecvendor_systeme_helmholz                   = 0x00000223,
    ecvendor_pantec                             = 0x00000225,
	ecvendor_vipa                               = 0x0000022b,
	ecvendor_weidmueller                        = 0x00000230,
	ecvendor_xian_jiaotong_university           = 0x00000233,
    ecvendor_abb_stotz_kontakt                  = 0x0000023a,
    ecvendor_berghof_automationstechnik         = 0x0000023b,
	ecvendor_ns_system                          = 0x0000023c,
	ecvendor_wiedemann                          = 0x0000023d,
	ecvendor_spezialantriebstechnik             = 0x00000240,
	ecvendor_harmonic_drive_ll                  = 0x00000247,
    ecvendor_stotz_feinmesstechnik              = 0x0000024f,
    ecvendor_dunkermotoren                      = 0x00000257,
	ecvendor_chengdu_crp                        = 0x00000256,
	ecvendor_fuji                               = 0x0000025e,
	ecvendor_trumpf_huettinger                  = 0x00000260,
	ecvendor_aros                               = 0x00000265,
	ecvendor_nanotec_electronic                 = 0x0000026c,
	ecvendor_me_messsysteme                     = 0x00000270,
	ecvendor_interroll_holding                  = 0x00000275,
	ecvendor_ish                                = 0x00000279,
	ecvendor_mkprecision                        = 0x00000280,
    ecvendor_roche_diagnostics                  = 0x00000283,
    ecvendor_toshiba_schneider                  = 0x00000284,
    ecvendor_bihl_wiedemann                     = 0x00000285,
    ecvendor_trinamic_motion_control            = 0x00000286,
	ecvendor_hdt                                = 0x00000289,
	ecvendor_horner                             = 0x00000292,
    ecvendor_performance_motion_devices         = 0x00000296,
	ecvendor_univer                             = 0x00000297,
	ecvendor_gerhartl                           = 0x0000029a,
    ecvendor_ingenia_cat                        = 0x0000029c,
    ecvendor_crevis                             = 0x0000029d,
	ecvendor_nimak                              = 0x000002ad,
	ecvendor_elap                               = 0x000002b4,
	ecvendor_advanced_energy                    = 0x000002b9,
	ecvendor_pba_systems                        = 0x000002ba,
	ecvendor_oriental_motor                     = 0x000002be,
	ecvendor_glentek                            = 0x000002c0,
	ecvendor_fronius                            = 0x000002c1,
    ecvendor_thk                                = 0x000002d0,
	ecvendor_samick                             = 0x000002d1,
	ecvendor_joint_peer_systec                  = 0x000002d3,
	ecvendor_halstrup_walcher                   = 0x000002d8,
	ecvendor_walcher                            = 0x000002d9,
	ecvendor_trio_motion                        = 0x000002de,
	ecvendor_servotronix                        = 0x000002e1,
	ecvendor_analytica                          = 0x000002eb,
	ecvendor_metal_work                         = 0x000002ee,
	ecvendor_kotmi                              = 0x00000300,
    ecvendor_digitronic                         = 0x00000302,
	ecvendor_dental_manufacturing               = 0x00000303,
	ecvendor_lam                                = 0x0000030c,
	ecvendor_iep                                = 0x0000030e,
	ecvendor_exceet                             = 0x00000311,
	ecvendor_kyung_motion                       = 0x00000312,
	ecvendor_pi_electronics                     = 0x00000314,
	ecvendor_toflo                              = 0x00000317,
	ecvendor_axis                               = 0x00000318,
	ecvendor_emtas                              = 0x00000319,
	ecvendor_codesys                            = 0x00000321,
	ecvendor_sibotech                           = 0x00000325,
	ecvendor_ge_intelligent                     = 0x00000326,
	ecvendor_shanghai_sany                      = 0x00000331,
	ecvendor_cybelec                            = 0x00000334,
	ecvendor_kostal                             = 0x00000337,
	ecvendor_rs_automation                      = 0x0000033d,
	ecvendor_kc_tech                            = 0x00000343,
	ecvendor_exlar                              = 0x00000344,
	ecvendor_draegerwerk                        = 0x0000034a,
	ecvendor_schaefer                           = 0x0000034d,
    ecvendor_infineon_technologies              = 0x0000034E,
	ecvendor_novatech                           = 0x00000367,
	ecvendor_tianjin_geneuo                     = 0x00000368,
	ecvendor_taian                              = 0x00000373,
	ecvendor_xmos                               = 0x0000037f,
	ecvendor_mks                                = 0x00000384,
	ecvendor_promicon                           = 0x0000038c,
	ecvendor_hein_lanz                          = 0x00000397,
	ecvendor_dieentwickler                      = 0x0000039d,
	ecvendor_larsys                             = 0x000003aa,
	ecvendor_procon                             = 0x000003ad,
    ecvendor_hanyang                            = 0x000003ae,
	ecvendor_j_schneider                        = 0x000003b0,
	ecvendor_motovario                          = 0x000003cc,
    ecvendor_baldor_uk                          = 0x000003db,
	ecvendor_lite_on                            = 0x000003e1,
	ecvendor_chieftek                           = 0x000003f5,
	ecvendor_fenac                              = 0x00000400,
	ecvendor_applied_motion                     = 0x00000404,
	ecvendor_shenzhen_xtec                      = 0x00000413,
	ecvendor_shenzhen_zmotion                   = 0x0000041b,
	ecvendor_pivotal_systems                    = 0x000004b3,
	ecvendor_randy_nuernberger                  = 0x000004b5,
	ecvendor_noda_radio                         = 0x000004d2,
	ecvendor_microchip                          = 0x000004d8,
	ecvendor_ketels                             = 0x00000500,
    ecvendor_beck_ipc                           = 0x00000501,
    ecvendor_etas                               = 0x00000502,
    ecvendor_phytec_messtechnik                 = 0x00000504,
    ecvendor_anca_motion                        = 0x00000505,
    ecvendor_fh_koeln                           = 0x00000506,
	ecvendor_ipg_automotive					    = 0x00000507,
    ecvendor_nuvation_research                  = 0x00000508,
    ecvendor_tr                                 = 0x00000509,
    ecvendor_gantner                            = 0x0000050a,
    ecvendor_mks_systems                        = 0x0000050b,
    ecvendor_abb_robotics                       = 0x0000050c,
    ecvendor_unitro_fleischmann                 = 0x0000050d,
    ecvendor_zub_machine_control                = 0x0000050e,
    ecvendor_dspace                             = 0x0000050f,
    ecvendor_samsung                            = 0x00000511,
    ecvendor_bce                                = 0x00000512,
    ecvendor_jaeger_messtechnik                 = 0x00000513,
    ecvendor_tetra                              = 0x00000514,
    ecvendor_justek                             = 0x00000515,
    ecvendor_baumer_thalheim                    = 0x00000516,
    ecvendor_elin_ebg_traction                  = 0x00000517,
    ecvendor_meka_robotics                      = 0x00000518,
    ecvendor_altera_japan                       = 0x00000519,
    ecvendor_ebv_elektronik                     = 0x0000051a,
    ecvendor_igh                                = 0x0000051b,
    ecvendor_iav                                = 0x0000051c,
    ecvendor_hitachi                            = 0x0000051d,
    ecvendor_tenasys                            = 0x0000051e,
    ecvendor_pondis                             = 0x0000051f,
    ecvendor_moog_italiana                      = 0x00000520,
    ecvendor_wallner_automation                 = 0x00000522,
    ecvendor_avl_list                           = 0x00000523,
    ecvendor_ritter_elektronik                  = 0x00000524,
    ecvendor_zwick                              = 0x00000527,
    ecvendor_dresdenelektronik                  = 0x00000528,
	ecvendor_tokyo_keiso 						= 0x00000529,
    ecvendor_philips_healthcare                 = 0x0000052c,
    ecvendor_chess                              = 0x0000052d,
    ecvendor_nct                                = 0x0000052e,
    ecvendor_anywire                            = 0x0000052f,
    ecvendor_shadow_robot                       = 0x00000530,
    ecvendor_fecon                              = 0x00000531,
    ecvendor_fh_suedwestfahlen                  = 0x00000532,
    ecvendor_add2                               = 0x00000533,
    ecvendor_arm_automation                     = 0x00000534,
    ecvendor_knapp_logistik                     = 0x00000537,
    ecvendor_getriebebau_nord                   = 0x00000538,
    ecvendor_yaskawa                            = 0x00000539,
    ecvendor_oki                                = 0x0000053a,
    ecvendor_takasaki_kyoudou                   = 0x0000053b,
    ecvendor_nittetsu_elex                      = 0x0000053c,
    ecvendor_unjo                               = 0x0000053e,
    ecvendor_eads_deutschland                   = 0x0000053f,
    ecvendor_acs_motion_control                 = 0x00000540,
    ecvendor_keyence                            = 0x00000541,
    ecvendor_mefi                               = 0x00000542,
    ecvendor_mut                                = 0x00000543,
    ecvendor_isw_uni_stuttgart                  = 0x00000544,
    ecvendor_elsena                             = 0x00000545,
    ecvendor_be_semiconductor                   = 0x00000546,
    ecvendor_hauni_lni                          = 0x00000547,
    ecvendor_etel                               = 0x00000548,
    ecvendor_vat_vakuumventile                  = 0x00000549,
    ecvendor_laytec                             = 0x0000054a,
    ecvendor_num                                = 0x0000054b,
    ecvendor_hauni_maschinenbau                 = 0x0000054c,
    ecvendor_exatronic                          = 0x0000054d,
    ecvendor_iim_chinese_aos                    = 0x0000054e,
    ecvendor_tu_eindhoven                       = 0x0000054f,
    ecvendor_scansonic                          = 0x00000550,
    ecvendor_shanghai_sodick_sw                 = 0x00000551,
    ecvendor_chuo_electronics                   = 0x00000552,
    ecvendor_agie                               = 0x00000553,
    ecvendor_hei_canton_de_vaud                 = 0x00000555,
    ecvendor_jenny_science                      = 0x00000557,
    ecvendor_industrial_control_communications  = 0x00000558,
    ecvendor_ckd_elektrotechnika                = 0x0000055a,
    ecvendor_qem                                = 0x0000055b,
    ecvendor_simatex                            = 0x0000055c,
    ecvendor_kithara                            = 0x0000055d,
    ecvendor_converteam                         = 0x0000055e,
    ecvendor_ara                                = 0x0000055f,
    ecvendor_tata_consultancy                   = 0x00000560,
	ecvendor_harmonic_drive                     = 0x00000561,
    ecvendor_tiab                               = 0x00000562,
    ecvendor_rkc_instrument                     = 0x00000563,
    ecvendor_switched_reluctance                = 0x00000564,
    ecvendor_avnet_electronics                  = 0x00000566,
    ecvendor_abb_force_measurement              = 0x00000567,
	ecvendor_yamaha_motor                       = 0x00000568,
    ecvendor_kunbus                             = 0x00000569,
    ecvendor_acd_antriebstechnik                = 0x0000056a,
    ecvendor_bronkhorst                         = 0x0000056b,
    ecvendor_k_mecs                             = 0x0000056c,
    ecvendor_thomson_broadcast                  = 0x0000056d,
    ecvendor_ufg_elettronica                    = 0x0000056e,
    ecvendor_xilinx                             = 0x0000056f,
    ecvendor_abb_power_systems                  = 0x00000570,
    ecvendor_servoland                          = 0x00000571,
    ecvendor_hivertec                           = 0x00000572,
    ecvendor_fike_europe                        = 0x00000573,
	ecvendor_omicron                            = 0x00000574,
	ecvendor_fike                               = 0x00000575,
    ecvendor_ropex                              = 0x00000576,
    ecvendor_tlu                                = 0x00000577,
    ecvendor_prodrive                           = 0x00000579,
    ecvendor_miho_inspektionssysteme            = 0x0000057a,
    ecvendor_tokyo_electron                     = 0x0000057b,
    ecvendor_lintec                             = 0x0000057c,
    ecvendor_simplex_vision                     = 0x0000057d,
	ecvendor_seiko_epson                        = 0x0000057e,
	ecvendor_zinser                             = 0x0000057f,
	ecvendor_abk_technology                     = 0x00000580,
    ecvendor_sus                                = 0x00000581,
    ecvendor_trsystems                          = 0x00000582,
    ecvendor_harmonic_drive_ag                  = 0x00000583,
    ecvendor_staeubli_faverges                  = 0x00000584,
    ecvendor_scienlab_electronic                = 0x00000585,
    ecvendor_fujisoft                           = 0x00000587,
    ecvendor_iai_corporation                    = 0x00000588,
    ecvendor_promavtomatika                     = 0x00000589,
    ecvendor_kistler_instrumente                = 0x0000058a,
    ecvendor_lauda_wobser                       = 0x0000058b,
    ecvendor_schweitzer_engineering_labs        = 0x0000058c,
	ecvendor_vital_systems 						= 0x0000058d,
    ecvendor_mutracx                            = 0x0000058e,
    ecvendor_algo                               = 0x0000058f,
    ecvendor_muehlbauer                         = 0x00000590,
	ecvendor_deto_drive						    = 0x00000591,
    ecvendor_sealevel_systems                   = 0x00000592,
    ecvendor_igm_robotersysteme                 = 0x00000593,
	ecvendor_wittenstein_electronics 	        = 0x00000594,
    ecvendor_zbe                                = 0x00000595,
    ecvendor_schneider_electric                 = 0x00000596,
    ecvendor_fraunhofer_iosb_ina                = 0x00000597,
    ecvendor_skf_magnetic_bearings              = 0x00000598,
    ecevndor_galil_motion_control               = 0x00000599,
    ecvendor_ihi                                = 0x0000059a,
    ecvendor_wenglor_sensoric                   = 0x0000059b,
    ecvendor_ingeteam                           = 0x0000059c,
    ecvendor_texas_instruments                  = 0xe000059d,
    ecvendor_micro_vu                           = 0x0000059e,
    ecvendor_oehri_electronic                   = 0x0000059f,
	ecvendor_triphase                           = 0x000005a0,
	ecvendor_glass_soft                         = 0x000005a1,
	ecvendor_cambridge_medical                  = 0x000005a2,
	ecvendor_china_machinery                    = 0x000005a3,
	ecvendor_kastanienbaum                      = 0x000005a4,
	ecvendor_hanyoung                           = 0x000005a5,
	ecvendor_sle_quality                        = 0x000005a6,
	ecvendor_omicron_nanotechnology             = 0x000005a7,
	ecvendor_micromeritics                      = 0x000005a8,
	ecvendor_trumpf                             = 0x000005a9,
	ecvendor_beratron                           = 0x000005ab,
	ecvendor_horiba                             = 0x000005aa,
	ecvendor_heinz                              = 0x000005ac,
	ecvendor_cebora                             = 0x000005ad,
	ecvendor_west                               = 0x000005ae,
	ecvendor_gomtec                             = 0x000005af,
	ecvendor_sieb_meyer                         = 0x000005b0,
	ecvendor_harbin                             = 0x000005b1,
	ecvendor_protechna_herbst                   = 0x000005b2,
	ecvendor_taeha                              = 0x000005b3,
	ecvendor_wittmann                           = 0x000005b4,
	ecvendor_iotec                              = 0x000005b5,
	ecvendor_prodel                             = 0x000005b6,
	ecvendor_leland_stanford_university         = 0x000005b7,
	ecvendor_tarasheh                           = 0x000005b8,
	ecvendor_cs_lab                             = 0x000005b9,
	ecvendor_elitron                            = 0x000005ba,
	ecvendor_koryo                              = 0x000005bb,
	ecvendor_shihlin                            = 0x000005bc,
	ecvendor_kookmin                            = 0x000005bd,
	ecvendor_techmation                         = 0x000005be,
	ecvendor_zapi                               = 0x000005bf,
	ecvendor_claus_pribbernow                   = 0x000005c0,
	ecvendor_pragati                            = 0x000005c1,
	ecvendor_siemens_software                   = 0x000005c2,
	ecvendor_micronova                          = 0x000005c3,
	ecvendor_xian_aerospace                     = 0x000005c4,
	ecvendor_mergenthaler                       = 0x000005c5,
	ecvendor_china_national_machinery           = 0x000005c6,
	ecvendor_berufliches_schulzentrum           = 0x000005c7,
	ecvendor_ndr                                = 0x000005c8,
	ecvendor_npk_msa                            = 0x000005c9,
	ecvendor_southeast_university               = 0x000005ca,
	ecvendor_shanghai_baosight                  = 0x000005cb,
	ecvendor_hakko                              = 0x000005cc,
	ecvendor_gmk                                = 0x000005cd,
	ecvendor_simtec                             = 0x000005ce,
	ecvendor_teconcept                          = 0x000005d0,
	ecvendor_ess                                = 0x000005d1,
	ecvendor_mabi                               = 0x000005d3,
	ecvendor_optoforce                          = 0x000005d4,
	ecvendor_toshiba_mitsubishi                 = 0x000005d5,
	ecvendor_wittenstein_ternary                = 0x000005d6,
	ecvendor_shanghai_friendess                 = 0x000005d7,
	ecvendor_aversan                            = 0x000005d8,
	ecvendor_lorch                              = 0x000005da,
	ecvendor_lotes                              = 0x000005d9,
	ecvendor_sungkyunkwan_university            = 0x000005db,
	ecvendor_tsinghua_university                = 0x000005dc,
	ecvendor_los_andes_university               = 0x000005dd,
	ecvendor_pfu                                = 0x000005de,
	ecvendor_slovak_university                  = 0x000005df,
	ecvendor_esomatec                           = 0x000005e0,
	ecvendor_lsis                               = 0x000005e1,
	ecvendor_statecore                          = 0x000005e2,
	ecvendor_kj_infinity                        = 0x000005e3,
	ecvendor_chic                               = 0x000005e4,
	ecvendor_littelfuse                         = 0x000005e5,
	ecvendor_itr                                = 0x000005e6,
	ecvendor_massachusetts_amherst_university   = 0x000005e8,
	ecvendor_pfeiffer                           = 0x000005e9,
	ecvendor_axor                               = 0x000005ea,
	ecvendor_quadrep                            = 0x000005eb,
	ecvendor_herrmann                           = 0x000005ec,
	ecvendor_precizika                          = 0x000005ed,
	ecvendor_shanghai_recat                     = 0x000005ee,
	ecvendor_u_and_r                            = 0x000005ef,
	ecvendor_xiamen                             = 0x000005f0,
	ecvendor_oilgear                            = 0x000005f1,
	ecvendor_mie                                = 0x000005f2,
	ecvendor_intech                             = 0x000005f3,
	ecvendor_starflight                         = 0x000005f5,
	ecvendor_ziehl_abegg                        = 0x000005f6,
	ecvendor_ackermann                          = 0x000005f7,
	ecvendor_helios                             = 0x000005f8,
	ecvendor_italsensor                         = 0x000005f9,
	ecvendor_sartorius                          = 0x000005fa,
	ecvendor_evergrid                           = 0x000005fb,
	ecvendor_germanjet                          = 0x000005fc,
	ecvendor_mapacode                           = 0x000005fd,
	ecvendor_biba                               = 0x000005fe,
	ecvendor_texas_university                   = 0x000005ff,
    ecvendor_nagano_oki                         = 0x00000600,
    ecvendor_condalo                            = 0x00000601,
	ecvendor_brooks                             = 0x00000602,
	ecvendor_florida_institute                  = 0x00000603,
	ecvendor_leica                              = 0x00000604,
	ecvendor_nabtesco                           = 0x00000605,
	ecvendor_bp_and_m                           = 0x00000606,
	ecvendor_optronic                           = 0x00000607,
	ecvendor_diamond                            = 0x00000608,
	ecvendor_estun                              = 0x0000060a,
	ecvendor_ims                                = 0x0000060b,
	ecvendor_m_system                           = 0x0000060c,
	ecvendor_ferrotec                           = 0x0000060d,
	ecvendor_sick                               = 0x0000060e,
	ecvendor_sinfoni                            = 0x00000610,
	ecvendor_pfeiffer_vacuum                    = 0x00000611,
	ecvendor_froude_hofmann                     = 0x00000612,
	ecvendor_sabo                               = 0x00000613,
	ecvendor_bystronic                          = 0x00000615,
	ecvendor_invt                               = 0x00000616,
	ecvendor_lumasense                          = 0x00000618,
	ecvendor_bbh                                = 0x00000619,
	ecvendor_hecht                              = 0x0000061a,
	ecvendor_xelmo                              = 0x0000061b,
	ecvendor_carl_zeiss                         = 0x0000061c,
	ecvendor_genova_university                  = 0x0000061d,
	ecvendor_jot                                = 0x0000061e,
	ecvendor_seisakusho                         = 0x0000061f,
	ecvendor_atv                                = 0x00000620,
	ecvendor_panasonic                          = 0x00000621,
	ecvendor_ifm                                = 0x00000622,
	ecvendor_fisher                             = 0x00000623,
	ecvendor_scle                               = 0x00000624,
	ecvendor_higen                              = 0x00000625,
	ecvendor_baumer                             = 0x00000626,
	ecvendor_moog_in                            = 0x00000627,
	ecvendor_xios                               = 0x00000628,
	ecvendor_azbil                              = 0x00000629,
	ecvendor_delta_tau                          = 0x0000062a,
	ecvendor_heraeus                            = 0x0000062b,
	ecvendor_esw                                = 0x0000062c,
	ecvendor_cg_drives                          = 0x0000062d,
	ecvendor_procom                             = 0x0000062e,
	ecvendor_alstom                             = 0x0000062f,
	ecvendor_robot                              = 0x00000630,
	ecvendor_brooks_automation                  = 0x00000631,
	ecvendor_hitachi_metals                     = 0x00000632,
	ecvendor_interroll                          = 0x00000633,
	ecvendor_ckd                                = 0x00000634,
	ecvendor_stiwa                              = 0x00000635,
	ecvendor_tpa                                = 0x00000636,
	ecvendor_guodian_nanjing                    = 0x00000637,
	ecvendor_prosoft                            = 0x00000638,
	ecvendor_polytype                           = 0x00000639,
	ecvendor_sensodrive                         = 0x0000063a,
	ecvendor_delta                              = 0x0000063b,
	ecvendor_friedrich_luetze                   = 0x0000063c,
	ecvendor_compressor_controls                = 0x0000063d,
	ecvendor_diamond_light                      = 0x0000063e,
	ecvendor_beckman                            = 0x0000063f,
	ecvendor_allied_motion                      = 0x00000640,
	ecvendor_nor_cal                            = 0x00000641,
	ecvendor_automata                           = 0x00000642,
	ecvendor_fraunhofer_institut_IWS            = 0x00000643,
	ecvendor_inficon                            = 0x00000644,
	ecvendor_hexagon                            = 0x00000645,
	ecvendor_shimadzu                           = 0x00000646,
	ecvendor_dasa                               = 0x00000647,
	ecvendor_shoei                              = 0x00000648,
	ecvendor_progressio                         = 0x00000649,
	ecvendor_maccon                             = 0x0000064a,
	ecvendor_moog_ireland                       = 0x0000064b,
	ecvendor_espera                             = 0x0000064c,
	ecvendor_w_plus_r                           = 0x0000064d,
	ecvendor_oceaneering                        = 0x0000064e,
	ecvendor_eostech                            = 0x0000064f,
	ecvendor_baptiste_de_baudre                 = 0x00000650,
	ecvendor_banja_luka_university              = 0x00000651,
	ecvendor_eding                              = 0x00000652,
	ecvendor_zuehlke                            = 0x00000653,
	ecvendor_addiva                             = 0x00000654,
	ecvendor_pteris                             = 0x00000655,
	ecvendor_chaos                              = 0x00000656,
	ecvendor_tokyo_institute                    = 0x00000657,
	ecvendor_seichter                           = 0x00000658,
	ecvendor_motion_control                     = 0x00000659,
	ecvendor_moog_nl                            = 0x0000065a,
	ecvendor_kinlo                              = 0x0000065b,
	ecvendor_cellsystems                        = 0x0000065c,
	ecvendor_shinano_kenshi                     = 0x0000065d,
	ecvendor_micro_epsilon                      = 0x0000065e,
	ecvendor_viable                             = 0x0000065f,
	ecvendor_kontron                            = 0x00000660,
	ecvendor_ik4                                = 0x00000661,
	ecvendor_hmk                                = 0x00000662,
	ecvendor_iit_institute                      = 0x00000664,
	ecvendor_qingdao_incman                     = 0x00000663,
	ecvendor_kashiyama                          = 0x00000665,
    ecvendor_tg_drives                          = 0x00000666,
	ecvendor_watlow                             = 0x00000667,
	ecvendor_synertronixx                       = 0x00000668,
	ecvendor_batalpha                           = 0x00000669,
	ecvendor_edwards                            = 0x0000066a,
	ecvendor_engel_au                           = 0x0000066b,
	ecvendor_fujikin                            = 0x0000066c,
	ecvendor_comet                              = 0x0000066d,
    ecvendor_schleuniger                        = 0x0000066e,
    ecvendor_panasonic_automotive_systems       = 0x0000066f,
	ecvendor_tangshan_kaiyuan                   = 0x00000670,
	ecvendor_solectrix                          = 0x00000671,
	ecvendor_cloud_state_university             = 0x00000672,
	ecvendor_jlg                                = 0x00000673,
	ecvendor_burckhardt                         = 0x00000674,
	ecvendor_rong_shun_xuan                     = 0x00000675,
	ecvendor_balluff_stm                        = 0x00000676,
	ecvendor_endress_hauser                     = 0x00000677,
	ecvendor_motor_power_company                = 0x00000678,
	ecvendor_ebi                                = 0x0000067a,
	ecvendor_hs_luzern                          = 0x0000067b,
	ecvendor_ge_global                          = 0x0000067c,
	ecvendor_universiteit_leuven                = 0x0000067d,
	ecvendor_ectronic                           = 0x0000067e,
	ecvendor_bundesamt                          = 0x0000067f,
	ecvendor_daihen                             = 0x00000680,
	ecvendor_hcl                                = 0x00000681,
	ecvendor_three_t                            = 0x00000682,
	ecvendor_eindhoven_university               = 0x00000683,
	ecvendor_innovent                           = 0x00000684,
	ecvendor_surrey                             = 0x00000685,
	ecvendor_ametek                             = 0x00000686,
	ecvendor_engleder                           = 0x00000687,
	ecvendor_pusan                              = 0x00000688,
	ecvendor_eth_zuerich                        = 0x00000689,
	ecvendor_berner_mattner                     = 0x0000068a,
	ecvendor_horiba_ltd                         = 0x0000068b,
	ecvendor_changwon_university                = 0x0000068c,
	ecvendor_penko                              = 0x0000068d,
	ecvendor_fujitsu                            = 0x0000068e,
	ecvendor_mirle                              = 0x00000690,
	ecvendor_fanuc                              = 0x00000691,
	ecvendor_kse                                = 0x00000692,
	ecvendor_euchner                            = 0x00000693,
	ecvendor_benjamin                           = 0x00000694,
	ecvendor_hans_laser                         = 0x00000695,
	ecvendor_guangdong_uni_automation           = 0x00000696,
	ecvendor_de_santa_catarina                  = 0x00000699,
	ecvendor_instrutech                         = 0x0000069a,
	ecvendor_ktl                                = 0x0000069b,
	ecvendor_hs_pforzheim                       = 0x0000069c,
	ecvendor_ewm                                = 0x0000069d,
	ecvendor_jilin_yongda                       = 0x0000069e,
	ecvendor_arrow                              = 0x0000069f,
	ecvendor_phoseon                            = 0x000006a0,
	ecvendor_item                               = 0x000006a1,
	ecvendor_shanghai_inno_drive                = 0x000006a2,
	ecvendor_wuhan                              = 0x000006a3,
	ecvendor_advanet                            = 0x000006a4,
	ecvendor_wandercraft                        = 0x000006a5,
	ecvendor_changzhou_xiangyun                 = 0x000006a6,
	ecvendor_santest                            = 0x000006a7,
	ecvendor_entesys                            = 0x000006a8,
	ecvendor_lot                                = 0x000006a9,
	ecvendor_asm                                = 0x000006aa,
	ecvendor_taiwan_pulse_motion                 = 0x000006ab,
	ecvendor_cni                                = 0x000006ac,
	ecvendor_enfas                              = 0x000006ad,
	ecvendor_megmeet_drive                      = 0x000006ae,
	ecvendor_danish_aerospace                   = 0x000006af,
	ecvendor_panasonic_production               = 0x000006b0,
	ecvendor_aradex                             = 0x000006b1,
	ecvendor_toyogiken                          = 0x000006b2,
	ecvendor_zao_trascon                        = 0x000006b3,
	ecvendor_arem                               = 0x000006b4,
	ecvendor_googol                             = 0x000006b5,
	ecvendor_vecna                              = 0x000006b6,
	ecvendor_tu_dresden                         = 0x000006b7,
	ecvendor_axxon                              = 0x000006b8,
	ecvendor_beijing_motrotech                  = 0x000006b9,
	ecvendor_woehner                            = 0x000006ba,
	ecvendor_hangzhou_tongling                  = 0x000006bb,
	ecvendor_audix                              = 0x000006bc,
	ecvendor_tu_wien                            = 0x000006bd,
	ecvendor_areva_np                           = 0x000006be,
	ecvendor_taurus_instruments                 = 0x000006bf,
	ecvendor_aveox                              = 0x000006c0,
	ecvendor_asml                               = 0x000006c1,
	ecvendor_haslerrail                         = 0x000006c2,
	ecvendor_intek                              = 0x000006c4,
	ecvendor_national_china                     = 0x000006c4,
	ecvendor_crouzet                            = 0x000006c5,
	ecvendor_joshua                             = 0x000006c7,
	ecvendor_artech                             = 0x000006c8,
	ecvendor_fuji_machinery                     = 0x000006ca,
	ecvendor_foshan_logen                       = 0x000006cb,
	ecvendor_dvdb                               = 0x000006cc,
	ecvendor_tess                               = 0x000006cd,
	ecvendor_king_giants                        = 0x000006ce,
	ecvendor_panax                              = 0x000006cf,
	ecvendor_hitachi_eu                         = 0x000006d0,
	ecvendor_zdauto_azdauto                     = 0x000006d1,
	ecvendor_temis                              = 0x000006d2,
	ecvendor_daikin                             = 0x000006d3,
	ecvendor_avalue                             = 0x000006d4,
	ecvendor_ldz                                = 0x000006d5,
	ecvendor_eletech                            = 0x000006d6,
	ecvendor_portwell                           = 0x000006d9,
	ecvendor_shenzhen_sine                      = 0x000006da,
	ecvendor_hildebrandt                        = 0x000006db,
	ecvendor_covidien                           = 0x000006dc,
	ecvendor_weintek                            = 0x000006dd,
	ecvendor_mitwell                            = 0x000006de,
	ecvendor_dorna                              = 0x000006df,
	ecvendor_am_consulting                      = 0x000006e0,
	ecvendor_genesi                             = 0x000006e1,
	ecvendor_molex                              = 0x000006e2,
	ecvendor_vanguard                           = 0x000006e3,
	ecvendor_ifatos                             = 0x000006e5,
	ecvendor_ingenieria                         = 0x000006e6,
	ecvendor_daekhon                            = 0x000006e7,
	ecvendor_marubeni                           = 0x000006ea,
	ecvendor_ydk                                = 0x000006eb,
	ecvendor_eta                                = 0x000006ec,
	ecvendor_justech                            = 0x000006ee,
	ecvendor_vollmer_werke                      = 0x000006f0,
	ecvendor_hs_georg_simon_ohm                 = 0x000006f1,
	ecvendor_gene                               = 0x000006f2,
	ecvendor_weihai_zheng                       = 0x000006f3,
	ecvendor_intervalzero                       = 0x000006f6,
	ecvendor_axonim                             = 0x000006f7,
	ecvendor_seoul_university                   = 0x000006f8,
	ecvendor_professional                       = 0x000006f9,
	ecvendor_shenyang_golding                   = 0x000006fc,
	ecvendor_iwaki                              = 0x000006fd,
	ecvendor_trp                                = 0x000006fe,
	ecvendor_epi_elettronica                    = 0x000006ff,
	ecvendor_iram                               = 0x00000700,
	ecvendor_tu_graz                            = 0x00000701,
	ecvendor_probeam                            = 0x00000702,
	ecvendor_servotechnica                      = 0x00000703,
	ecvendor_hanwha                             = 0x00000704,
	ecvendor_g_and_s                            = 0x00000705,
	ecvendor_schaeffler                         = 0x00000706,
	ecvendor_basque_university                  = 0x00000707,
	ecvendor_arges                              = 0x00000708,
	ecvendor_control_chief                      = 0x00000709,
	ecvendor_konplan                            = 0x0000070a,
	ecvendor_embex                              = 0x0000070b,
	ecvendor_cosmotechs                         = 0x0000070c,
	ecvendor_dynamic                            = 0x0000070d,
	ecvendor_semikron                           = 0x0000070e,
	ecvendor_wuxi_ivoyage                       = 0x0000070f,
	ecvendor_caf                                = 0x00000710,
	ecvendor_smart                              = 0x00000711,
	ecvendor_yokogawa                           = 0x00000712,
	ecvendor_norwegian_university               = 0x00000713,
	ecvendor_robostar                           = 0x00000714,
	ecvendor_trumpf_werkzeugmaschinen           = 0x00000715,
	ecvendor_high_performance                   = 0x00000716,
	ecvendor_kozaka                             = 0x00000717,
	ecvendor_aeronautical_systems               = 0x00000718,
	ecvendor_agile                              = 0x00000719,
	ecvendor_hon_hai                            = 0x0000071a,
	ecvendor_systeme_plus_steuerungen           = 0x0000071b,
	ecvendor_huron                              = 0x0000071c,
	ecvendor_souther_switzerland_dti            = 0x0000071d,
	ecvendor_mako                               = 0x0000071e,
	ecvendor_rainer_thomas                      = 0x0000071f,
	ecvendor_eltek                              = 0x00000720,
	ecvendor_vecow                              = 0x00000721,
	ecvendor_m_and_p                            = 0x00000722,
	ecvendor_leybold                            = 0x00000723,
	ecvendor_panasonic_america                  = 0x00000725,
	ecvendor_eilersen                           = 0x00000726,
	ecvendor_inter                              = 0x00000727,
	ecvendor_power_instrument                   = 0x00000728,
	ecvendor_coswort                            = 0x00000729,
	ecvendor_south_china_uni_mae                = 0x0000072a,
	ecvendor_warwick                            = 0x0000072b,
	ecvendor_shenzhen_invt                      = 0x0000072c,
	ecvendor_wiedeg                             = 0x0000072d,
	ecvendor_nke                                = 0x0000072e,
	ecvendor_madrid_university                  = 0x0000072f,
	ecvendor_bot_and_dolly                      = 0x00000730,
	ecvendor_recif                              = 0x00000731,
	ecvendor_ati                                = 0x00000732,
	ecvendor_advantest                          = 0x00000733,
	ecvendor_multivac                           = 0x00000734,
	ecvendor_roland                             = 0x00000735,
	ecvendor_contec                             = 0x00000736,
	ecvendor_alizem                             = 0x00000737,
	ecvendor_chyng_hong                         = 0x00000738,
	ecvendor_yaskawa_america                    = 0x00000739,
	ecvendor_georg_schlegel                     = 0x0000073a,
	ecvendor_faraday                            = 0x0000073b,
	ecvendor_sipro                              = 0x0000073c,
	ecvendor_twente_university                  = 0x0000073d,
	ecvendor_aalborg_university                 = 0x0000073e,
	ecvendor_s_sys_bvba                         = 0x0000073f,
	ecvendor_ningbo_mingpu                      = 0x00000740,
	ecvendor_elrest                             = 0x00000741,
	ecvendor_kyosan                             = 0x00000742,
	ecvendor_custom                             = 0x00000743,
	ecvendor_kfm                                = 0x00000744,
	ecvendor_ishida                             = 0x00000745,
	ecvendor_beijing_university                 = 0x00000746,
	ecvendor_hannifin                           = 0x00000747,
	ecvendor_tsino_dynatron                     = 0x00000748,
	ecvendor_penta                              = 0x00000749,
	ecvendor_china_university                   = 0x0000074a,
	ecvendor_altus                              = 0x0000074b,
	ecvendor_sanming                            = 0x0000074c,
	ecvendor_jenoptik                           = 0x0000074e,
	ecvendor_beijing_knd                        = 0x0000074f,
	ecvendor_jw_shannon                         = 0x00000750,
	ecvendor_a2v                                = 0x00000751,
	ecvendor_nexcom                             = 0x00000752,
	ecvendor_jiangyin_huafeng                   = 0x00000753,
	ecvendor_lectra                             = 0x00000754,
	ecvendor_beijer                             = 0x00000755,
	ecvendor_cj_hartman                         = 0x00000756,
	ecvendor_hurco                              = 0x00000757,
	ecvendor_autonics                           = 0x00000759,
	ecvendor_brom                               = 0x0000075a,
	ecvendor_vrije_university                   = 0x0000075b,
	ecvendor_alluris                            = 0x0000075c,
	ecvendor_hs_offenburg                       = 0x0000075d,
	ecvendor_heidolph                           = 0x0000075f,
	ecvendor_ge_transportation                  = 0x00000760,
	ecvendor_maex                               = 0x00000761,
	ecvendor_durst                              = 0x00000762,
	ecvendor_omsk_university                    = 0x00000763,
	ecvendor_embedded_bonjour                   = 0x00000764,
	ecvendor_mettler_toledo                     = 0x00000765,
    ecvendor_renesas                            = 0x00000766,
	ecvendor_lju                                = 0x00000767,
	ecvendor_eura_drives                        = 0x00000768,
	ecvendor_eutron                             = 0x00000769,
	ecvendor_flanders                           = 0x0000076a,
	ecvendor_digital_dynamics                   = 0x0000076b,
	ecvendor_ge_medical                         = 0x0000076c,
	ecvendor_physik_instumente                  = 0x0000076d,
	ecvendor_hypertherm                         = 0x0000076e,
	ecvendor_hrid                               = 0x0000076f,
	ecvendor_aotai                              = 0x00000770,
	ecvendor_control_concepts                   = 0x00000771,
	ecvendor_jovetech                           = 0x00000772,
	ecvendor_pohang_university                  = 0x00000773,
	ecvendor_cyclomedia                         = 0x00000774,
	ecvendor_sun_tectro                         = 0x00000775,
	ecvendor_jiao_tong_university               = 0x00000776,
    ecvendor_koenig                             = 0x00000777,
	ecvendor_anton_paar                         = 0x00000778,
	ecvendor_v_tex                              = 0x00000779,
	ecvendor_edge_technologies                  = 0x0000077a,
	ecvendor_ebara                              = 0x0000077b,
	ecvendor_buffalo_university                 = 0x0000077c,
	ecvendor_aurotek                            = 0x0000077d,
	ecvendor_blubit                             = 0x0000077e,
	ecvendor_toplens                            = 0x0000077f,
	ecvendor_chung_cheng_university             = 0x00000780,
	ecvendor_hexagon_tech_centre                = 0x00000781,
	ecvendor_graph_tech                         = 0x00000782,
	ecvendor_lanthan                            = 0x00000783,
	ecvendor_nucleus                            = 0x00000784,
	ecvendor_stratec                            = 0x00000785,
	ecvendor_wien_university                    = 0x00000786,
	ecvendor_inno_spec                          = 0x00000787,
	ecvendor_thyssenkrupp                       = 0x00000788,
	ecvendor_denso_wave                         = 0x0000078a,
	ecvendor_eurosoft                           = 0x0000078b,
	ecvendor_british_columbia_university        = 0x0000078c,
	ecvendor_renergy_tianjin                    = 0x0000078d,
	ecvendor_newyoungsystem                     = 0x0000078e,
	ecvendor_selema                             = 0x0000078f,
	ecvendor_reading_university                 = 0x00000790,
	ecvendor_koganei                            = 0x00000791,
	ecvendor_mazet                              = 0x00000792,
	ecvendor_nottingham_university              = 0x00000793,
	ecvendor_quanta                             = 0x00000794,
	ecvendor_azbil_taishin                      = 0x00000795,
	ecvendor_relitech                           = 0x00000796,
	ecvendor_dhpc                               = 0x00000797,
	ecvendor_jordan_valley                      = 0x00000798,
	ecvendor_microcreate                        = 0x00000799,
	ecvendor_ab_and_t                           = 0x0000079a,
	ecvendor_t3lab                              = 0x0000079c,
	ecvendor_coptonix                           = 0x0000079d,
	ecvendor_karl_mayer                         = 0x0000079e,
	ecvendor_inoson                             = 0x0000079f,
	ecvendor_ge_power                           = 0x000007a0,
	ecvendor_shanghai_yuanzhi                   = 0x000007a1,
	ecvendor_oyo                                = 0x000007a2,
	ecvendor_solwit                             = 0x000007a3,
	ecvendor_jabil_circuit                      = 0x000007a4,
	ecvendor_renesas_semiconductor              = 0x000007a5,
	ecvendor_tu_berlin                          = 0x000007a6,
	ecvendor_mettler_toledo_changzhou           = 0x000007a7,
	ecvendor_sentronic                          = 0x000007a8,
	ecvendor_leas                               = 0x000007a9,
	ecvendor_mapna                              = 0x000007aa,
	ecvendor_nettechnix_e_and_p                 = 0x000007ab,
	ecvendor_integrated_dynamics                = 0x000007ad,
	ecvendor_toho                               = 0x000007ae,
	ecvendor_salvagnini                         = 0x000007af,
	ecvendor_shanghai_triowin                   = 0x000007b0,
	ecvendor_hytec                              = 0x000007b1,
	ecvendor_xian_xiangxun                      = 0x000007b2,
	ecvendor_schmidiger                         = 0x000007b3,
	ecvendor_master                             = 0x000007b4,
	ecvendor_korea_university                   = 0x000007b5,
	ecvendor_h_kufferath                        = 0x000007b6,
	ecvendor_eftec                              = 0x000007b7,
	ecvendor_dfc                                = 0x000007b9,
	ecvendor_fukuda                             = 0x000007ba,
	ecvendor_fh_flensburg                       = 0x000007bb,
	ecvendor_karlsruher_institut                = 0x000007bc,
	ecvendor_burnon                             = 0x000007bd,
	ecvendor_nuova                              = 0x000007be,
	ecvendor_yuban                              = 0x000007bf,
	ecvendor_ricoh                              = 0x000007c2,
	ecvendor_rdc                                = 0x000007c3,
	ecvendor_setex_schermuly                    = 0x000007c4,
	ecvendor_elowerk                            = 0x000007c5,
	ecvendor_ithemba_labs                       = 0x000007c6,
	ecvendor_cncsazan                           = 0x000007c8,
	ecvendor_shiningview                        = 0x000007c9,
	ecvendor_mikysek                            = 0x000007ca,
	ecvendor_victron                            = 0x000007cb,
	ecvendor_michigan                           = 0x000007cd,
	ecvendor_adfweb                             = 0x000007ce,
	ecvendor_nortion                            = 0x000007cf,
	ecvendor_gigatronik                         = 0x000007d0,
	ecvendor_zhejiang_synmot                    = 0x000007d1,
	ecvendor_hk_mns                             = 0x000007d2,
	ecvendor_tattile                            = 0x000007d3,
	ecvendor_elfin                              = 0x000007d4,
	ecvendor_bimba                              = 0x000007d5,
	ecvendor_winsonic                           = 0x000007d6,
	ecvendor_dimetix                            = 0x000007d7,
	ecvendor_genetec                            = 0x000007d8,
	ecvendor_tianjin_hengxin                    = 0x000007d9,
	ecvendor_sfa                                = 0x000007da,
	ecvendor_opticon                            = 0x000007db,
	ecvendor_npn                                = 0x000007dc,
	ecvendor_wuhan_maxsine                      = 0x000007dd,
	ecvendor_concept_overdrive                  = 0x000007df,
	ecvendor_hetronik                           = 0x000007e0,
	ecvendor_jbt                                = 0x000007e2,
	ecvendor_tu_dresden_eit                     = 0x000007e3,
	ecvendor_dajo                               = 0x000007e4,
	ecvendor_criterio                           = 0x000007e5,
	ecvendor_quanzhou                           = 0x000007e6,
	ecvendor_data_tecno                         = 0x000007e7,
	ecvendor_rainbow_springs                    = 0x000007e8,
	ecvendor_renu                               = 0x000007e9,
	ecvendor_max_planck_institut                = 0x000007ea,
	ecvendor_intelligent_automation_zhuhai      = 0x000007eb,
	ecvendor_screen_holdings_ltd                = 0x000007ec,
	ecvendor_sysmex                             = 0x000007ed,
	ecvendor_asm_jp                             = 0x000007ee,
	ecvendor_imago                              = 0x000007ef,
	ecvendor_happiest_minds                     = 0x000007f0,
	ecvendor_open_control_system                = 0x000007f1,
	ecvendor_seoul_uni_engg                     = 0x000007f2,
	ecvendor_ulvac                              = 0x000007f3,
	ecvendor_meliora                            = 0x000007f4,
	ecvendor_toshiba_corp                       = 0x000007f5,
	ecvendor_schnell                            = 0x000007f6,
	ecvendor_itiri                              = 0x000007f7,
	ecvendor_4pico                              = 0x000007f8,
	ecvendor_set                                = 0x000007f9,
	ecvendor_changnam                           = 0x000007fa,
	ecvendor_shanghai_ruking                    = 0x000007fb,
	ecvendor_meta                               = 0x000007fc,
	ecvendor_ghm                                = 0x000007fd,
	ecvendor_xihua_university                   = 0x000007ff,
	ecvendor_otsl                               = 0x00000801,
	ecvendor_aromasoft                          = 0x00000802,
	ecvendor_bobst                              = 0x00000803,
	ecvendor_tessera                            = 0x00000805,
	ecvendor_jwiesemann                         = 0x00000806,
	ecvendor_ulasim_san                         = 0x00000807,
	ecvendor_prophotonix                        = 0x00000808,
	ecvendor_datennetze                         = 0x00000809,
	ecvendor_stefan_cel_mare_university         = 0x0000080a,
	ecvendor_modrol                             = 0x0000080b,
	ecvendor_obs                                = 0x0000080c,
	ecvendor_jiao_tong_uni_mech                 = 0x0000080d,
	ecvendor_team                               = 0x0000080e,
	ecvendor_southwest_university               = 0x0000080f,
	ecvendor_tdk_lambda                         = 0x00000810,
	ecvendor_ta_liang                           = 0x00000811,
	ecvendor_ccs                                = 0x00000812,
	ecvendor_adaptronic                         = 0x00000813,
	ecvendor_toho_electronics                   = 0x00000814,
	ecvendor_third_eye                          = 0x00000815,
	ecvendor_nikki_denso                        = 0x00000816,
	ecvendor_systematic                         = 0x00000817,
	ecvendor_peritec                            = 0x00000818,
	ecvendor_bachmann                           = 0x00000819,
	ecvendor_bmk                                = 0x0000081a,
	ecvendor_teco                               = 0x0000081b,
	ecvendor_mechtronic_industries              = 0x0000081c,
	ecvendor_mernok                             = 0x0000081d,
	ecvendor_bremen_university                  = 0x0000081e,
	ecvendor_hydro_quebec                       = 0x0000081f,
	ecvendor_gemtec                             = 0x00000820,
	ecvendor_sintef_raufoss                     = 0x00000821,
	ecvendor_advanced_manufacturing             = 0x00000822,
	ecvendor_levitronix                         = 0x00000823,
	ecvendor_carsten_spiess                     = 0x00000825,
	ecvendor_reivax                             = 0x00000826,
	ecvendor_lappeenranta_university            = 0x00000827,
	ecvendor_totani                             = 0x00000828,
	ecvendor_serad                              = 0x00000829,
	ecvendor_itw_dynatec                        = 0x0000082a,
	ecvendor_hs_emden                           = 0x0000082b,
	ecvendor_jfcontrol                          = 0x0000082c,
	ecvendor_sael                               = 0x0000082d,
	ecvendor_beckman_coulter                    = 0x0000082e,
	ecvendor_walter                             = 0x0000082f,
	ecvendor_alterface                          = 0x00000830,
	ecvendor_lectronix                          = 0x00000831,
	ecvendor_hokuyo                             = 0x00000832,
	ecvendor_shanghai_empower                   = 0x00000833,
	ecvendor_thyracont                          = 0x00000834,
	ecvendor_omax                               = 0x00000835,
	ecvendor_tox_pressotechnik                  = 0x00000836,
	ecvendor_chiao_tung_university              = 0x00000837,
	ecvendor_inspiro                            = 0x00000838,
	ecvendor_maxcess                            = 0x00000839,
	ecvendor_chell                              = 0x0000083a,
	ecvendor_fuji_machine                       = 0x0000083b,
	ecvendor_nidec_sankyo                       = 0x0000083c,
	ecvendor_shizuoka_oki                       = 0x0000083d,
	ecvendor_frencken                           = 0x0000083e,
	ecvendor_granite                            = 0x0000083f,
	ecvendor_agilicom                           = 0x00000842,
	ecvendor_philips_technologie                = 0x00000843,
	ecvendor_kla_tencor                         = 0x00000844,
	ecvendor_meidensha                          = 0x00000845,
	ecvendor_rolls_royce                        = 0x00000849,
	ecvendor_west_bohemia_university            = 0x0000084a,
	ecvendor_keri                               = 0x0000084b,
	ecvendor_mpi                                = 0x0000084c,
	ecvendor_roeders                            = 0x0000084d,
	ecvendor_melec                              = 0x0000084e,
	ecvendor_mianyang_weibo                     = 0x0000084f,
	ecvendor_wuhan_huazhong                     = 0x00000851,
	ecvendor_datalogic                          = 0x00000852,
	ecvendor_tri_tek                            = 0x00000853,
	ecvendor_yuheng                             = 0x00000855,
	ecvendor_eth                                = 0x00000856,
	ecvendor_jtekt                              = 0x00000857,
	ecvendor_ergo                               = 0x00000858,
	ecvendor_engineerdream                      = 0x00000859,
	ecvendor_samsung_electronics                = 0x0000085a,
	ecvendor_ksj                                = 0x0000085b,
	ecvendor_messer                             = 0x0000085c,
	ecvendor_krones                             = 0x0000085d,
	ecvendor_northwestern_university            = 0x0000085f,
	ecvendor_blackbird                          = 0x00000860,
	ecvendor_mitsuba                            = 0x00000861,
	ecvendor_foshan_shunde                      = 0x00000863,
	ecvendor_men_mikro                          = 0x00000864,
	ecvendor_thermo_fisher                      = 0x00000865,
	ecvendor_pyramid                            = 0x00000866,
	ecvendor_verity                             = 0x00000867,
	ecvendor_kai_plus                           = 0x00000868,
	ecvendor_texas_a_and_m                      = 0x00000869,
	ecvendor_fpt                                = 0x0000086a,
	ecvendor_machinex                           = 0x0000086b,
	ecvendor_shanghai_rising_digital            = 0x0000086c,
	ecvendor_sick_optex                         = 0x0000086d,
	ecvendor_laserline                          = 0x0000086e,
	ecvendor_xpress                             = 0x0000086f,
	ecvendor_electra                            = 0x00000870,
	ecvendor_magnescale                         = 0x00000871,
	ecvendor_hitachi_kokusai                    = 0x00000872,
	ecvendor_hangzhou_jingwei                   = 0x00000873,
	ecvendor_shanghai_lynuc                     = 0x00000874,
	ecvendor_atla                               = 0x00000875,
	ecvendor_edac_hangzhou                      = 0x00000876,
	ecvendor_mycom                              = 0x00000877,
	ecvendor_foxconn                            = 0x00000879,
	ecvendor_qinhuangdao                        = 0x0000087a,
	ecvendor_sia_china                          = 0x0000087b,
	ecvendor_deere                              = 0x0000087c,
	ecvendor_leibniz_university                 = 0x0000087d,
	ecvendor_eltro                              = 0x0000087f,
	ecvendor_uk_grid                            = 0x00000880,
	ecvendor_control_gaging                     = 0x00000881,
	ecvendor_hfe                                = 0x00000883,
	ecvendor_schnier                            = 0x00000885,
	ecvendor_wuhan_huagong                      = 0x00000886,
	ecvendor_zhejiang_keqiang                   = 0x00000888,
	ecvendor_impedans                           = 0x00000889,
	ecvendor_chinese_academy                    = 0x0000088a,
	ecvendor_gccalliance                        = 0x0000088b,
	ecvendor_interface                          = 0x0000088c,
	ecvendor_nec                                = 0x0000088d,
	ecvendor_shenyang                           = 0x0000088e,
	ecvendor_tq_systems                         = 0x0000088f,
	ecvendor_shanghai_panelmate                 = 0x00000890,
	ecvendor_haute_ecole_arc                    = 0x00000891,
	ecvendor_kitech_korea                       = 0x00000892,
	ecvendor_ceta                               = 0x00000893,
	ecvendor_step                               = 0x00000895,
	ecvendor_dalian_guangyang                   = 0x00000896,
	ecvendor_hermes                             = 0x00000897,
	ecvendor_kawasaki_heavy                     = 0x00000898,
	ecvendor_elco                               = 0x00000899,
	ecvendor_neuromeka                          = 0x0000089a,
	ecvendor_semes                              = 0x0000089d,
	ecvendor_d2t                                = 0x0000089e,
	ecvendor_plasmart                           = 0x0000089f,
	ecvendor_drescher                           = 0x000008a0,
	ecvendor_mk_system                          = 0x000008a1,
	ecvendor_bebro                              = 0x000008a2,
	ecvendor_mc_monitoring                      = 0x000008a3,
	ecvendor_variable                           = 0x000008a4,
	ecvendor_dukane                             = 0x000008a5,
	ecvendor_mecatronix                         = 0x000008a6,
	ecvendor_prima_power                        = 0x000008a7,
	ecvendor_isocomp                            = 0x000008a8,
	ecvendor_shinko                             = 0x000008a9,
	ecvendor_asec                               = 0x000008aa,
	ecvendor_rtc                                = 0x000008ab,
	ecvendor_entegris                           = 0x000008ac,
	ecvendor_asem                               = 0x000008ad,
	ecvendor_agie_charmilles                    = 0x000008ae,
	ecvendor_zhengzhou_changhe                  = 0x000008af,
	ecvendor_leister                            = 0x000008b0,
	ecvendor_saginomiya                         = 0x000008b2,
	ecvendor_advantech_lnc                      = 0x000008b3,
	ecvendor_guangdong_elesy                    = 0x000008b4,
	ecvendor_shanghai_inrevium                  = 0x000008b5,
	ecvendor_toyo                               = 0x000008b6,
	ecvendor_de_bretagne_sud_university         = 0x000008b7,
	ecvendor_shenzhen_zhiyou                    = 0x000008b8,
	ecvendor_malema                             = 0x000008b9,
	ecvendor_ricoh_industrial                   = 0x000008bb,
	ecvendor_tri_city                           = 0x000008bc,
	ecvendor_rutronik                           = 0x000008bd,
	ecvendor_sanei_hytechs                      = 0x000008be,
	ecvendor_delixi                             = 0x000008bf,
	ecvendor_ritz                               = 0x000008c0,
	ecvendor_ricoh_company                      = 0x000008c1,
	ecvendor_tae                                = 0x000008c2,
	ecvendor_fontys                             = 0x000008c3,
	ecvendor_hangzhou_riding                    = 0x000008c4,
	ecvendor_atlas_copco                        = 0x000008c5,
	ecvendor_mindtribe                          = 0x000008c6,
	ecvendor_criq                               = 0x000008c7,
	ecvendor_elster                             = 0x000008c8,
	ecvendor_panasonic_idst                     = 0x000008c9,
	ecvendor_stv                                = 0x000008ca,
	ecvendor_hentschel                          = 0x000008cb,
	ecvendor_gree                               = 0x000008cc,
	ecvendor_futurestar                         = 0x000008cd,
	ecvendor_para_ent                           = 0x000008ce,
	ecvendor_siasun                             = 0x000008cf,
	ecvendor_wfe                                = 0x000008d0,
	ecvendor_drivexpert                         = 0x000008d1,
	ecvendor_luebeck_university                 = 0x000008d2,
	ecvendor_branson                            = 0x000008d4,
	ecvendor_rolls_royce_ntulab                 = 0x000008d5,
	ecvendor_guilin_stars                       = 0x000008d6,
	ecvendor_ace_designers                      = 0x000008d7,
	ecvendor_varian                             = 0x000008d9,
	ecvendor_damedics                           = 0x000008da,
	ecvendor_energopromavtomatizaciya           = 0x000008db,
	ecvendor_microsure                          = 0x000008dc,
	ecvendor_finisar                            = 0x000008de,
	ecvendor_planet_technology                  = 0x000008df,
	ecvendor_pees_components                    = 0x000008e0,
	ecvendor_lumberg                            = 0x000008e1,
	ecvendor_nachi_fujikoshi                    = 0x000008e2,
	ecvendor_radic                              = 0x000008e4,
	ecvendor_weightpack                         = 0x000008e5,
	ecvendor_bs2                                = 0x000008e6,
	ecvendor_sumitomo                           = 0x000008e7,
	ecvendor_spectra_physics                    = 0x000008e8,
	ecvendor_apptronik                          = 0x000008e9,
	ecvendor_s_haussmann                        = 0x000008ea,
	ecvendor_great_river                        = 0x000008eb,
	ecvendor_eltra                              = 0x000008ec,
	ecvendor_sinobonder                         = 0x000008ed,
	ecvendor_robotous                           = 0x000008ee,
	ecvendor_tianjin_sentinel                   = 0x000008ef,
	ecvendor_izovac                             = 0x000008f0,
	ecvendor_kosice_university                  = 0x000008f1,
	ecvendor_sanmei                             = 0x000008f2,
	ecvendor_ea_elektro                         = 0x000008f3,
	ecvendor_dynamic_motion                     = 0x000008f4,
	ecvendor_ooo_pkf                            = 0x000008f5,
	ecvendor_shanghai_maihong                   = 0x000008f6,
	ecvendor_china_harvest                      = 0x000008f7,
	ecvendor_astem_kyoto                        = 0x000008f8,
	ecvendor_mini_motor                         = 0x000008f9,
	ecvendor_bitifeye                           = 0x000008fa,
	ecvendor_ibis                               = 0x000008fb,
	ecvendor_hanbit                             = 0x000008fc,
	ecvendor_tateyama_kagaku                    = 0x000008fd,
	ecvendor_aone                               = 0x000008ff,
    ecvendor_shanghai_cnc                       = 0x00000900,
	ecvendor_bose                               = 0x00000901,
	ecvendor_flow                               = 0x00000902,
	ecvendor_anritsu                            = 0x00000904,
	ecvendor_emerson_solahd                     = 0x00000906,
	ecvendor_modusoft                           = 0x00000907,
	ecvendor_sichuan                            = 0x00000908,
	ecvendor_intron                             = 0x00000909,
	ecvendor_jimei_university                   = 0x0000090a,
	ecvendor_core                               = 0x0000090c,
	ecvendor_hib                                = 0x0000090d,
	ecvendor_nova_fabrica                       = 0x0000090e,
	ecvendor_rota                               = 0x0000090f,
	ecvendor_shenzhen_vmmore                    = 0x00000911,
	ecvendor_leibniz_uni_eit                    = 0x00000912,
	ecvendor_saft                               = 0x00000914,
	ecvendor_star_denshi                        = 0x00000915,
	ecvendor_marposs                            = 0x00000916,
	ecvendor_china_orient                       = 0x00000917,
	ecvendor_cosys                              = 0x00000918,
	ecvendor_shenzhen_vector                    = 0x00000919,
	ecvendor_intravis                           = 0x0000091b,
	ecvendor_drobak                             = 0x0000091c,
	ecvendor_georg_simon_ohm                    = 0x0000091d,
	ecvendor_zenitron                           = 0x0000091e,
	ecvendor_wuhan_endeavor                     = 0x0000091f,
	ecvendor_leadjeck                           = 0x00000920,
	ecvendor_fujian_raynen                      = 0x00000922,
	ecvendor_demcon                             = 0x00000923,
	ecvendor_serva                              = 0x00000924,
	ecvendor_shenyang_neusoft                   = 0x00000925,
	ecvendor_ruhr                               = 0x00000926,
	ecvendor_banner                             = 0x00000927,
	ecvendor_guangdong_topstar                  = 0x00000929,
	ecvendor_evinsys                            = 0x0000092a,
	ecvendor_shenzhen_huacheng                  = 0x0000092b,
	ecvendor_mondragon                          = 0x0000092c,
	ecvendor_katholieke                         = 0x0000092d,
	ecvendor_ekso_bionics                       = 0x0000092e,
	ecvendor_kaufman_und_robinson               = 0x0000092f,
	ecvendor_ksm_electronic                     = 0x00000930,
	ecvendor_technical_and_try                  = 0x00000932,
	ecvendor_maxcom                             = 0x00000935,
	ecvendor_national                           = 0x00000936,
	ecvendor_ryoei                              = 0x00000937,
	ecvendor_schaeffler_technologies            = 0x00000938,
	ecvendor_nts_group                          = 0x00000939,
	ecvendor_tekt                               = 0x0000093b,
	ecvendor_xian_aerospace_automation          = 0x0000093c,
	ecvendor_gal                                = 0x0000093d,
	ecvendor_toa                                = 0x0000093e,
	ecvendor_friedrich_alexander_university     = 0x00000940,
	ecvendor_sirius                             = 0x00000941,
	ecvendor_chengdu_inplus                     = 0x00000942,
	ecvendor_microstep                          = 0x00000943,
	ecvendor_murata                             = 0x00000944,
	ecvendor_cabinplant                         = 0x00000946,
	ecvendor_franka_emika                       = 0x00000948,
	ecvendor_smart_move                         = 0x0000094a,
	ecvendor_ampere                             = 0x0000094b,
	ecvendor_imkon_endustriyel                  = 0x0000094d,
	ecvendor_tangshan                           = 0x0000094e,
	ecvendor_christian_albrechts                = 0x0000094f,
	ecvendor_lorraine_university                = 0x00000950,
	ecvendor_fraunhofer_institut_optronik       = 0x00000951,
	ecvendor_ip_automatika                      = 0x00000952,
	ecvendor_emko                               = 0x00000953,
	ecvendor_fine                               = 0x00000954,
	ecvendor_uk_atc                             = 0x00000955,
	ecvendor_itmems                             = 0x00000956,
	ecvendor_lumasense_inc                      = 0x00000957,
	ecvendor_acutronic                          = 0x00000958,
	ecvendor_diebie                             = 0x00000959,
	ecvendor_procept                            = 0x0000095a,
	ecvendor_new_power                          = 0x0000095b,
	ecvendor_amtc                               = 0x0000095c,
	ecvendor_asm_singapore                      = 0x0000095d,
	ecvendor_weigl                              = 0x0000095e,
	ecvendor_wagner                             = 0x0000095f,
	ecvendor_liebherr                           = 0x00000960,
	ecvendor_mechatronic                        = 0x00000961,
	ecvendor_jiangsu_torsung                    = 0x00000962,
	ecvendor_sluzby_bahoza                      = 0x00000963,
	ecvendor_itr_institute                      = 0x00000964,
	ecvendor_beijing_bit                        = 0x00000965,
	ecvendor_elastisense                        = 0x00000966,
	ecvendor_north_china_university             = 0x00000967,
	ecvendor_nidec                              = 0x00000968,
	ecvendor_interface_devices                  = 0x0000096a,
	ecvendor_nikon                              = 0x0000096b,
	ecvendor_fujitsu_component                  = 0x0000096c,
	ecvendor_jiaxing_dealour                    = 0x0000096d,
	ecvendor_eth_zuerich_iris                   = 0x0000096e,
	ecvendor_suruga                             = 0x0000096f,
	ecvendor_advanio                            = 0x00000970,
	ecvendor_embl_hamburg                       = 0x00000971,
	ecvendor_suruga_seiki                       = 0x00000973,
	ecvendor_eva                                = 0x00000974,
	ecvendor_beijing_etechwin                   = 0x00000975,
	ecvendor_ke_elektronik                      = 0x00000976,
	ecvendor_accrea_bartlomiej                  = 0x00000977,
	ecvendor_schunk                             = 0x00000978,
	ecvendor_sciaky                             = 0x00000979,
	ecvendor_tokyo_robotics                     = 0x0000097a,
	ecvendor_embeddeers_g                       = 0x0000097c,
	ecvendor_gamaco                             = 0x0000097d,
	ecvendor_npp                                = 0x0000097e,
	ecvendor_fuji_electronics                   = 0x00000980,
	ecvendor_shenzhen_mingsu                    = 0x00000981,
	ecvendor_jiangsu_ysphotech                  = 0x00000982,
	ecvendor_beijing_jcz                        = 0x00000983,
	ecvendor_dmg_mori                           = 0x00000984,
	ecvendor_telsonic                           = 0x00000985,
	ecvendor_ncworks                            = 0x00000987,
	ecvendor_van_mierlo                         = 0x00000988,
	ecvendor_control_technology                 = 0x00000989,
	ecvendor_teac                               = 0x0000098a,
	ecvendor_crossworks                         = 0x0000098d,
	ecvendor_agility                            = 0x0000098e,
	ecvendor_shenzhen_double                    = 0x0000098f,
	ecvendor_tsc                                = 0x00000991,
	ecvendor_te_connectivity                    = 0x00000992,
	ecvendor_shenzhen_yako                      = 0x00000994,
	ecvendor_prettl                             = 0x00000995,
	ecvendor_xiamen_kehua                       = 0x00000997,
	ecvendor_mayser                             = 0x00000998,
	ecvendor_haitian                            = 0x00000999,
	ecvendor_waco                               = 0x0000099a,
	ecvendor_mike_and_weingartner               = 0x0000099b,
	ecvendor_ionicon                            = 0x0000099c,
	ecvendor_inesc_tec                          = 0x0000099d,
	ecvendor_four_automation                    = 0x0000099e,
	ecvendor_moog_ind                           = 0x0000099f,
	ecvendor_capetown_university                = 0x000009a0,
	ecvendor_auris                              = 0x000009a1,
	ecvendor_ilmenau_university                 = 0x000009a3,
	ecvendor_hit_special                        = 0x000009a4,
	ecvendor_smartdv                            = 0x000009a5,
	ecvendor_visitech                           = 0x000009a6,
	ecvendor_solartron                          = 0x000009a7,
	ecvendor_nksystem                           = 0x000009a8,
	ecvendor_intronix                           = 0x000009a9,
	ecvendor_netmodule                          = 0x000009aa,
	ecvendor_bz_robot                           = 0x000009ab,
	ecvendor_pues                               = 0x000009ac,
	ecvendor_shs                                = 0x000009ad,
	ecvendor_manter                             = 0x000009ae,
	ecvendor_delft_university                   = 0x000009af,
	ecvendor_gamade                             = 0x000009b0,
	ecvendor_ima_tec                            = 0x000009b1,
	ecvendor_evest                              = 0x000009b2,
	ecvendor_shinko_technos                     = 0x000009b3,
	ecvendor_sichuan_university                 = 0x000009b4,
	ecvendor_flc_zbigniew                       = 0x000009b5,
	ecvendor_taizhou_topcut                     = 0x000009b6,
	ecvendor_shiratech                          = 0x000009b7,
	ecvendor_eastern_logic                      = 0x000009b9,
	ecvendor_weber_schraubautomaten             = 0x000009ba,
	ecvendor_power_solution                     = 0x000009bb,
	ecvendor_advanced_thermal_sciences          = 0x000009bc,
	ecvendor_kitz                               = 0x000009be,
	ecvendor_motorcon                           = 0x000009bf,
	ecvendor_clownfish                          = 0x000009c0,
	ecvendor_rabe                               = 0x000009c1,
	ecvendor_ghost                              = 0x000009c2,
	ecvendor_socionext                          = 0x000009c5,
	ecvendor_shenzhen_best_motion               = 0x000009c6,
	ecvendor_escad                              = 0x000009c7,
	ecvendor_laval_university                   = 0x000009c8,
	ecvendor_mbtech                             = 0x000009ca,
	ecvendor_ams                                = 0x000009cb,
	ecvendor_techno_holon                       = 0x000009cc,
	ecvendor_j_zimmer                           = 0x000009cd,
	ecvendor_e_sigma                            = 0x000009ce,
	ecvendor_omron_hangzhou                     = 0x000009cf,
	ecvendor_sof_tek                            = 0x000009d0,
	ecvendor_contrinex                          = 0x000009d1,
	ecvendor_sise                               = 0x000009d2,
	ecvendor_christ                             = 0x000009d3,
	ecvendor_hosta_motion                       = 0x000009d4,
	ecvendor_spintrol                           = 0x000009d5,
	ecvendor_tema                               = 0x000009d6,
	ecvendor_franz_sprenger                     = 0x000009d7,
	ecvendor_opto4l                             = 0x000009d8,
	ecvendor_quest                              = 0x000009d9,
	ecvendor_zis                                = 0x000009db,
	ecvendor_lovato                             = 0x000009dc,
	ecvendor_e2m                                = 0x000009dd,
	ecvendor_zefatek                            = 0x000009de,
	ecvendor_birket                             = 0x000009df,
	ecvendor_jd                                 = 0x000009e0,
	ecvendor_ica                                = 0x000009e1,
	ecvendor_okano                              = 0x000009e2,
	ecvendor_shenzhen_new_medical               = 0x000009e3,
	ecvendor_j_schmalz                          = 0x000009e4,
	ecvendor_fives                              = 0x000009e5,
	ecvendor_innocontact                        = 0x000009e6,
	ecvendor_silex                              = 0x000009e7,
	ecvendor_shinmaywa                          = 0x000009e8,
	ecvendor_ib_prozessleittechnik              = 0x000009e9,
	ecvendor_ejtech                             = 0x000009ea,
	ecvendor_shenzhen_hymson                    = 0x000009eb,
	ecvendor_flashcut                           = 0x000009ec,
	ecvendor_beijing_ctb                        = 0x000009ed,
	ecvendor_alexander_binzel                   = 0x000009ee,
	ecvendor_sawamura_denki                     = 0x000009ef,
	ecvendor_robowell                           = 0x000009f0,
	ecvendor_muse                               = 0x000009f1,
	ecvendor_shenzhen_wellauto                  = 0x000009f2,
	ecvendor_aignep                             = 0x000009f4,
	ecvendor_pusan_national_uni                 = 0x000009f5,
	ecvendor_kumoh_mach                         = 0x000009f6,
	ecvendor_imp_china                          = 0x000009f7,
	ecvendor_houston                            = 0x000009f8,
	ecvendor_iar_systems                        = 0x000009f9,
	ecvendor_koshida                            = 0x000009fa,
	ecvendor_advanced_micro_fab                 = 0x000009fb,
	ecvendor_stephanix                          = 0x000009fc,
	ecvendor_cpi                                = 0x000009fd,
	ecvendor_harris                             = 0x000009fe,
	ecvendor_suzhou_agioe                       = 0x000009ff,
	ecvendor_optoelectronics                    = 0x00000a00,
	ecvendor_abb_swiss                          = 0x00000a01,
	ecvendor_fms_force                          = 0x00000a02,
	ecvendor_kulicke_and_soffa                  = 0x00000a03,
	ecvendor_hexmoto                            = 0x00000a04,
    ecvendor_mitsubishi                         = 0x00000a1e,
	ecvendor_think_surgical                     = 0x00000aaa,
	ecvendor_abb_research                       = 0x00000abb,
	ecvendor_afag                               = 0x00000afa,
	ecvendor_shanghai_velle                     = 0x00000b7b,
	ecvendor_asix                               = 0x00000b95,
	ecvendor_hanbaek                            = 0x00000bcf,
	ecvendor_bruker_daltonik                    = 0x00000bdd,
	ecvendor_bangkok_university                 = 0x00000bea,
	ecvendor_cordova_integradores               = 0x00000c11,
	ecvendor_seoul_uni                          = 0x00000ccb,
	ecvendor_cea                                = 0x00000cea,
    ecvendor_john_deere                         = 0x00000d05,
	ecvendor_deif                               = 0x00000d0f,
	ecvendor_wipro                              = 0x00000dad,
	ecvendor_dee_draexlmaier                    = 0x00000dee,
	ecvendor_digital_feedback                   = 0x00000df3,
	ecvendor_four_technos                       = 0x00000e88,
	ecvendor_ecs_sistemi                        = 0x00000ec5,
	ecvendor_espotel                            = 0x00000eee,
	ecvendor_motiv                              = 0x00001000,
	ecvendor_jcast_networks                     = 0x00001024,
	ecvendor_matrox                             = 0x0000102b,
	ecvendor_veltru                             = 0x0000103b,
	ecvendor_toshiba                            = 0x00001048,
	ecvendor_beijing                            = 0x000010fa,
	ecvendor_a_kyung                            = 0x00001110,
	ecvendor_mls_lanny                          = 0x00001111,
    ecvendor_cantops                            = 0x00001122,
    ecvendor_ids                                = 0x000012ad,
	ecvendor_ferag                              = 0x00001132,
	ecvendor_profichip                          = 0x0000115c,
	ecvendor_k_tronic                           = 0x0000115f,
	ecvendor_east_group                         = 0x00001204,
	ecvendor_contexa                            = 0x00001219,
	ecvendor_rt_labs                            = 0x00001337,
	ecvendor_cosmo                              = 0x00001357,
	ecvendor_advantech                          = 0x000013fe,
    ecvendor_adlink                             = 0x0000144a,
    ecvendor_eubus                              = 0x0000147a,
	ecvendor_precise                            = 0x000014ff,
    ecvendor_unico                              = 0x00001502,
	ecvendor_ono_sokki 							= 0x0000150e,
	ecvendor_helmholtz_zentrum 					= 0x00001600,
    ecvendor_dlr                                = 0x00001616,
	ecvendor_linke_und_ruehe 					= 0x00001701,
    ecvendor_hei_canton_de_vaud_reds            = 0x0000179a,
	ecvendor_tamagawa_seiki                     = 0x00001800,
	ecvendor_fujian_huafeng                     = 0x00001818,
	ecvendor_hagenuk                            = 0x00001899,
	ecvendor_sacmi_imola                        = 0x00001919,
	ecvendor_amada                              = 0x00001946,
	ecvendor_hanmi                              = 0x00001980,
	ecvendor_laumas                             = 0x00001984,
	ecvendor_dina                               = 0x00001987,
	ecvendor_shenzhen_samkoon                   = 0x00001991,
	ecvendor_pushcorp                           = 0x00001993,
	ecvendor_syn_tek                            = 0x00001a05,
    ecvendor_bystorm                            = 0x00001a21,
	ecvendor_michel_van_de_wiele                = 0x00001a85,
    ecvendor_ipetronik                          = 0x00001a90,
	ecvendor_opal_rt                            = 0x00001b2c,
    ecvendor_sennheiser                         = 0x00001b66,
	ecvendor_nextec                             = 0x00002001,
	ecvendor_ruethi                             = 0x000021de,
	ecvendor_bristol_robotics_lab               = 0x00002055,
	ecvendor_kinova                             = 0x000022cd,
	ecvendor_synapticon                         = 0x000022d2,
    ecvendor_danieli_automation                 = 0x00002304,
	ecvendor_nanjing_sciyon                     = 0x00002380,
	ecvendor_eo_technics                        = 0x00002501,
	ecvendor_mcs_engenharia                     = 0x00002727,
	ecvendor_rollmann                           = 0x000027ab,
	ecvendor_burster                            = 0x00002838,
	ecvendor_meiji                              = 0x00003388,
	ecvendor_sanlab_yazilm                      = 0x000033aa,
	ecvendor_matrixgroup                        = 0x000033c3,
	ecvendor_four_c                             = 0x00003443,
	ecvendor_purpose                            = 0x00003508,
	ecvendor_eprolinktek                        = 0x00003610,
	ecvendor_ubi                                = 0x00003777,
	ecvendor_basel_university                    = 0x00004123,
    ecvendor_acontis                            = 0x00004154,
	ecvendor_leadshine                          = 0x00004321,
	ecvendor_myostat                            = 0x00004441,
	ecvendor_energy                             = 0x00004553,
	ecvendor_shanghai                           = 0x00004567,
	ecvendor_fukoku_tokai                       = 0x00004654,
	ecvendor_sandensha                          = 0x00004685,
	ecvendor_fraba                              = 0x00004711,
	ecvendor_generic_robotics                   = 0x00004752,
	ecvendor_interworks                         = 0x00004957,
	ecvendor_kratzer                            = 0x00004b41,
	ecvendor_sks_control                        = 0x00004d43,
	ecvendor_tsuzuki_denki                      = 0x00005050,
	ecvendor_prestosolution                     = 0x00005053,
	ecvendor_roesch_and_walter                  = 0x00005257,
	ecvendor_sohoaid                            = 0x00005341,
	ecvendor_kristl                             = 0x00005995,
	ecvendor_maurizio_ferraris                  = 0x00005f5f,
	ecvendor_gerber                             = 0x00006084,
    ecvendor_kuka                               = 0x000060c8,
	ecvendor_shenzhen_huanan                    = 0x00006145,
	ecvendor_beijing_jingwei_hirain             = 0x00006432,
	ecvendor_qingdao_university                 = 0x00006666,
	ecvendor_gsolar_power                       = 0x00006688,
	ecvendor_china_electronics_university       = 0x00006789,
	ecvendor_beijing_jingdiao                   = 0x00006a64,
    ecvendor_nat                                = 0x00006c78,
	ecvendor_thermal_dynamics                   = 0x00007071,
	ecvendor_mahr                               = 0x00007073,
	ecvendor_hyundai_heavy                      = 0x00007170,
	ecvendor_toyota_motor                       = 0x00007203,
	ecvendor_yunke_intelligent                  = 0x00007217,
    ecvendor_mecapion                           = 0x00007595,
    ecvendor_ontec                              = 0x00007604,
	ecvendor_hunan_super                        = 0x00007680,
    ecvendor_foxnum                             = 0x00007715,
    ecvendor_kyoei                              = 0x00007716,
	ecvendor_sheltronics                        = 0x00007777,
	ecvendor_nissin                             = 0x00007880,
	ecvendor_tait                               = 0x00007a17,
	ecvendor_tec5                               = 0x00007ec5,
	ecvendor_satyam                             = 0x00008027,
	ecvendor_china_cepri                        = 0x00008281,
	ecvendor_raonwoori                          = 0x00008421,
    ecvendor_brother                            = 0x00008562,
	ecvendor_akribis                            = 0x00008800,
    ecvendor_shenyang_machine_tool              = 0x00008818,
	ecvendor_harbin_institute                   = 0x000088f6,
	ecvendor_sigmatek                           = 0x000088fa,
	ecvendor_aixtron                            = 0x00008909,
	ecvendor_zhejiang_university                = 0x00008a8c,
	ecvendor_shotover                           = 0x00009300,
	ecvendor_saurer                             = 0x00009320,
	ecvendor_shenzhen_hans                      = 0x00009434,
    ecvendor_soft_servo                         = 0x00009555,
	ecvendor_sungrow                            = 0x00009638,
	ecvendor_vie                                = 0x00009863,
	ecvendor_amoy_xiamen                        = 0x00009999,
	ecvendor_mdsi                               = 0x0000a2a2,
	ecvendor_atse                               = 0x0000a75e,
	ecvendor_muscle                             = 0x0000aa77,
	ecvendor_hiwin                              = 0x0000aaaa,
	ecvendor_rmit_university                    = 0x0000ab57,
	ecvendor_beijing_juntai                     = 0x0000abab,
	ecvendor_triamec                            = 0x0000abba,
	ecvendor_topcon_agriculture                 = 0x0000ad84,
	ecvendor_fraunhofer_ilt_2                   = 0x0000adda,
	ecvendor_anedo                              = 0x0000aed0,
	ecvendor_galaxy_fareast                     = 0x0000afec,
    ecvendor_vipa_visualsierung                 = 0x0000affe,
	ecvendor_orsys_orth                         = 0x0000b02a,
	ecvendor_viveris                            = 0x0000b0ce,
	ecvendor_sensa                              = 0x0000bb80,
	ecvendor_brainchild                         = 0x0000bc00,
	ecvendor_beta_dyn                           = 0x0000be7a,
    ecvendor_gd                                 = 0x0000bebe,
	ecvendor_national_radio_astronomy           = 0x0000beef,
	ecvendor_riedl                              = 0x0000c0de,
	ecvendor_cisa                               = 0x0000c15a,
	ecvendor_jiangsu_cptek                      = 0x0000c918,
	ecvendor_sotec                              = 0x0000cafe,
    ecvendor_keba_at                            = 0x0000ceba,
	ecvendor_dabo                               = 0x0000dab0,
	ecvendor_dalian_university                  = 0x0000de88,
	ecvendor_potomac                            = 0x0000deda,
	ecvendor_esab                               = 0x0000e5ab,
	ecvendor_meastream                          = 0x0000eaea,
	ecvendor_emmission                          = 0x0000eca7,
    ecvendor_willow_garage                      = 0x0000eeee,
	ecvendor_shanghai_passiontech               = 0x0000effe,
	ecvendor_imagos_di_renato                   = 0x0000f0ca,
	ecvendor_fab_9                              = 0x0000fab9,
	ecvendor_kirp_korea                         = 0x0000face,
    ecvendor_interroll_trommelmotoren           = 0x0000fe09,
    ecvendor_silica_avnet                       = 0x0000fedc,
	ecvendor_harbin_inst_Technology             = 0x0000ff66,
	ecvendor_ueno_seiki                         = 0x0000fffe,
	ecvendor_rb3d                               = 0x0000ffaa,
	ecvendor_robotiq                            = 0x0000ffff,
	ecvendor_hitachi_terminal                   = 0x00010001,
	ecvendor_glidewell                          = 0x00010101,
	ecvendor_beijing_saintwise                  = 0x00010151,
	ecvendor_beijing_sunwise                    = 0x00010502,
	ecvendor_servotecnica_spa                   = 0x00010780,
	ecvendor_utthunga                           = 0x00011107,
	ecvendor_beijing_university_posts           = 0x00011111,
	ecvendor_carl_zeiss_optotechnik             = 0x000144ab,
	ecvendor_carl_zeiss_smt                     = 0x00023155,
	ecvendor_sichuan_dongfang                   = 0x00028dec,
	ecvendor_xp_power                           = 0x00030004,
	ecvendor_sioux                              = 0x0003030d,
	ecvendor_syswork                            = 0x00040716,
	ecvendor_sick_inc                           = 0x00051c4b,
	ecvendor_hunan_matrix                       = 0x00073188,
	ecvendor_shenzhen_tongchuan                 = 0x00075500,
	ecvendor_itk                                = 0x00076761,
	ecvendor_alexan                             = 0x00088888,
	ecvendor_nanjing_daqo                       = 0x00099099,
	ecvendor_cornelius                          = 0x000a7b00,
	ecvendor_quality_firmware                   = 0x000be11a,
	ecvendor_yes_energy                         = 0x000c0c0c,
	ecvendor_chroma_ate                         = 0x000c1984,
	ecvendor_toshiba_transport                  = 0x000e1048,
	ecvendor_opvengineering                     = 0x000f1016,
	ecvendor_shenzhen_inovance                  = 0x00100000,
	ecvendor_serwis                             = 0x00102030,
	ecvendor_sbs_science                        = 0x00104104,
	ecvendor_zhejiang_feida                     = 0x00111111,
	ecvendor_robotic_systems                    = 0x00111713,
	ecvendor_youngtek                           = 0x00112233,
	ecvendor_beijing_mechatronical              = 0x00120187,
	ecvendor_eraetech                           = 0x00123456,
	ecvendor_easy_etudes                        = 0x00124816,
	ecvendor_beijing_richauto                   = 0x00136013,
	ecvendor_ulvac_automation                   = 0x00141003,
	ecvendor_shenyang_xbang                     = 0x00150306,
	ecvendor_start_to_sail                      = 0x00161718,
	ecvendor_wu_yang                            = 0x00168888,
	ecvendor_smartray                           = 0x00178200,
	ecvendor_ningbo_yunsheng                    = 0x00181818,
	ecvendor_kayser_threde                      = 0x00190050,
	ecvendor_ege_robotics                       = 0x00190683,
	ecvendor_tallinn_university                 = 0x001918ee,
	ecvendor_tallinn_university_it              = 0x001919ee,
	ecvendor_meerecompany                       = 0x00203040,
	ecvendor_research_and_production            = 0x00220110,
	ecvendor_fpt_software                       = 0x00223344,
	ecvendor_emotion                            = 0x00228100,
	ecvendor_hrk_brk                            = 0x00231970,
	ecvendor_nanjing_chenguang                  = 0x00250001,
	ecvendor_manner                             = 0x00250993,
	ecvendor_smart_testsolutions                = 0x00255210,
	ecvendor_meinhard_koppitz                   = 0x00260954,
	ecvendor_ruag_defence                       = 0x00290968,
	ecvendor_creasoft                           = 0x00308012,
	ecvendor_shanghai_rui_fast                  = 0x00340702,
	ecvendor_egle                               = 0x00361300,
	ecvendor_viewmove                           = 0x00404040,
    ecvendor_altima                             = 0x00414c54,
	ecvendor_anybotics                          = 0x00414e59,
	ecvendor_apl_landau                         = 0x0041504c,
	ecvendor_ailux                              = 0x00416c78,
	ecvendor_seren                              = 0x00424345,
	ecvendor_cit_chiba                          = 0x00434954,
	ecvendor_cambridge_micro_engg               = 0x00434d45,
	ecvendor_cimon                              = 0x00434d4e,
	ecvendor_d_and_v                            = 0x00442656,
	ecvendor_distek                             = 0x00444949,
	ecvendor_astrodyne                          = 0x00444950,
	ecvendor_daewoo                             = 0x00445345,
	ecvendor_electronic_theatre                 = 0x00455443,
	ecvendor_itmo_university                    = 0x00455453,
	ecvendor_envision_jiangsu                   = 0x00456e76,
	ecvendor_future_electronics                 = 0x00465554,
	ecvendor_ginolis                            = 0x0047494e,
	ecvendor_innodelec                          = 0x00481417,
	ecvendor_hexagon_metrology                  = 0x00484d30,
	ecvendor_headspring                         = 0x00485349,
    ecvendor_kuhnke                             = 0x0048554B,
	ecvendor_hv_sistemas                        = 0x00485653,
	ecvendor_ibv_echtzeit                       = 0x00494256,
	ecvendor_icp_das                            = 0x00494350,
	ecvendor_irt                                = 0x00495254,
	ecvendor_seoul_precision                    = 0x00499816,
    ecvendor_jat                                = 0x004A4154,
	ecvendor_linz_center                        = 0x004c434d,
	ecvendor_lithoz                             = 0x004c545a,
	ecvendor_mas_systec                         = 0x004d4153,
	ecvendor_chr_mayr                           = 0x004d4159,
    ecvendor_heidelberger                       = 0x004d4448,
    ecvendor_mecalc                             = 0x004d4543,
	ecvendor_volga_state_university             = 0x004d5249,
	ecvendor_narae_nanotech                     = 0x004e4154,
	ecvendor_nemonos                            = 0x004e454d,
	ecvendor_opsens                             = 0x004f5053,
	ecvendor_ormec_systems                      = 0x004f524d,
	ecvendor_posco                              = 0x00502654,
	ecvendor_pc_krause                          = 0x0050434b,
	ecvendor_powersparks                        = 0x00505347,
	ecvendor_paul_scherrer                      = 0x00505349,
	ecvendor_packsize                           = 0x0050535a,
	ecvendor_shanghai_volboff                   = 0x00515151,
	ecvendor_daegu_gyeongbuk                    = 0x00524254,
    ecvendor_samsung_sec                        = 0x00534543,
	ecvendor_starfire                           = 0x00534649,
	ecvendor_sfera                              = 0x00534652,
	ecvendor_sg_electronic                      = 0x00534745,
	ecvendor_ssi                                = 0x00535349,
	ecvendor_tokyo_electron_ltd                 = 0x0054454c,
	ecvendor_tem_tech                           = 0x0054454d,
	ecvendor_tomen                              = 0x00544d45,
	ecvendor_ste_trekwer                        = 0x00544e4d,
	ecvendor_team_new_zealand                   = 0x00544e5a,
	ecvendor_tronteq_electronic                 = 0x00545145,
	ecvendor_techman                            = 0x00545249,
	ecvendor_sakarya_universityent              = 0x00545454,
	ecvendor_js_automation                      = 0x00546936,
	ecvendor_ueidaq                             = 0x00554549,
	ecvendor_jiangxi_fashion                    = 0x00555555,
	ecvendor_shenzhen_v_and_t                   = 0x00556666,
	ecvendor_vmi                                = 0x00564d49,
	ecvendor_weatherford                        = 0x00574654,
	ecvendor_witium                             = 0x00574954,
	ecvendor_inca                               = 0x00577800,
	ecvendor_cerebrus                           = 0x00578485,
	ecvendor_xiamen_micromatch                  = 0x00584d4d,
	ecvendor_hangzhou_zhenzheng                 = 0x005a5a5a,
	ecvendor_zygo                               = 0x005a7967,
	ecvendor_google                             = 0x00600613,
    ecvendor_aixcon                             = 0x00616978,
	ecvendor_maple                              = 0x00643000,
	ecvendor_yuchang                            = 0x00654321,
	ecvendor_changzhou                          = 0x00666666,
	ecvendor_bilko                              = 0x00667675,
	ecvendor_kinco_electric                     = 0x00681168,
	ecvendor_shenzhen_hengketong                = 0x00690069,
	ecvendor_mianyang_fude                      = 0x00696969,
	ecvendor_kjellberg_finsterwalde             = 0x006b4f53,
	ecvendor_shodensha                          = 0x006c6267,
	ecvendor_cyber_control                      = 0x00700100,
	ecvendor_ponutech                           = 0x00706e74,
	ecvendor_mechadept                          = 0x00746568,
	ecvendor_bst_eltromat                       = 0x00746c65,
	ecvendor_rainbow                            = 0x00770712,
	ecvendor_sentrol_ltd                        = 0x00777700,
	ecvendor_hangzhou_dianzi_university         = 0x00777777,
	ecvendor_devol_advanced                     = 0x00789456,
	ecvendor_chengdu_yanxing                    = 0x00796866,
	ecvendor_metis                              = 0x0079796d,
	ecvendor_goldluecke                         = 0x00799245,
	ecvendor_microtime                          = 0x00811791,
	ecvendor_kist_1                             = 0x00830517,
	ecvendor_kist_2                             = 0x00830518,
	ecvendor_shenzhen_veichi                    = 0x00850104,
	ecvendor_atop                               = 0x00880088,
	ecvendor_simplo                             = 0x00886688,
	ecvendor_hitachi_hightech                   = 0x00888882,
	ecvendor_dongguan_avatar                    = 0x00889606,
	ecvendor_hangzhou_wahaha                    = 0x00889999,
	ecvendor_smartind                           = 0x00999999,
	ecvendor_opsens_soutions                    = 0x00a0415e,
	ecvendor_shanghai_maritime_university       = 0x00a1234f,
	ecvendor_aselsa                             = 0x00a5e15a,
	ecvendor_inventec_shanghai                  = 0x00aa0001,
	ecvendor_bitvis                             = 0x00aa55a5,
	ecvendor_shenzhen_sipake                    = 0x00aa55aa,
	ecvendor_altera                             = 0x00aaaaaa,
	ecvendor_abatec                             = 0x00aba1ec,
	ecvendor_promotion_comercio                 = 0x00abf159,
	ecvendor_enders                             = 0x00acce55,
	ecvendor_hanyang_robotics                   = 0x00aceace,
	ecvendor_analog_devices                     = 0x00adcafe,
    ecvendor_kk_electronic                      = 0x00ae4b4b,
	ecvendor_hofo                               = 0x00ae86fd,
	ecvendor_pal                                = 0x00b071c5,
	ecvendor_moog_animatics                     = 0x00c0ffee,
	ecvendor_largan                             = 0x00cccccc,
	ecvendor_china_electronics_21               = 0x00ce7c21,
	ecvendor_rexa                               = 0x00d02379,
	ecvendor_dave                               = 0x00da4e00,
	ecvendor_daeati                             = 0x00daeac0,
	ecvendor_dain_cube                          = 0x00dddddd,
	ecvendor_shanghai_xpartner                  = 0x00deadbf,
	ecvendor_eso_eu                             = 0x00e50e50,
	ecvendor_weld_tooling                       = 0x00e5ca18,
	ecvendor_tongtai                            = 0x00ec1608,
	ecvendor_promax                             = 0x00ec1991,
	ecvendor_hitex_uk                           = 0x00ec4800,
	ecvendor_mecademic                          = 0x00ecade1,
	ecvendor_stoegra                            = 0x00edc0de,
	ecvendor_entec_electric                     = 0x00ee00aa,
	ecvendor_henan_college                      = 0x00eee669,
	ecvendor_eonyk                              = 0x00eeeeee,
	ecvendor_williams_grand                     = 0x00f1f1f1,
	ecvendor_koyo                               = 0x00fa140a,
	ecvendor_gtd_sistemas                       = 0x00fabada,
	ecvendor_kemppi                             = 0x00fe0001,
	ecvendor_chongqing_huashu                   = 0x00ffffff,
	ecvendor_arlington_lab                      = 0x01000001,
    ecvendor_sick_ag                            = 0x01000056,
	ecvendor_omron_adept                        = 0x01000083,
    ecvendor_parker_hannifin_id2                = 0x01000089,
    ecvendor_balluf                             = 0x010000e8,
	ecvendor_control_techniques                 = 0x010000f9,
	ecvendor_shanghai_sany_science              = 0x01000331,
	ecvendor_infineon_technologies_us           = 0x0100034e,
	ecvendor_renesas_korea                      = 0x01000766,
	ecvendor_bimba_manufacturing                = 0x010007d5,
	ecvendor_screen_holdings                    = 0x010007ec,
	ecvendor_frencken_us                        = 0x0100083e,
	ecvendor_kla_tencor_corp                    = 0x01000844,
	ecvendor_edac_electronics_hangzhou          = 0x01000876,
	ecvendor_core_corp                          = 0x0100090c,
	ecvendor_drobak_unlimited                   = 0x0100091c,
	ecvendor_amada_miyachi                      = 0x01001946,
	ecvendor_eprolinktek_ltd                    = 0x01003610,
	ecvendor_hyundai_heavy_ltd                  = 0x01007170,
	ecvendor_hunan_super_information            = 0x01007680,
	ecvendor_fraunhofer_lasertechnik_ilt        = 0x0100adda,
	ecvendor_kinco_electric_schenzen            = 0x01681168,
	ecvendor_time                               = 0x012ebc73,
    ecvendor_ma_vi                              = 0x01abcdef,
    ecvendor_kraeutner_software                 = 0x01c0ffee,
    ecvendor_parker_hannifin_eme                = 0x02000089,
    ecvendor_danfoss_drives                     = 0x0200008d,
	ecvendor_fraunhofer_ilt 					= 0x0200adda,
	ecvendor_shanghai_sany_sciencetech          = 0x02000331,
	ecvendor_infineon_technologies_china        = 0x0200034e,
    ecvendor_parker_hannifin_eme_630            = 0x03000089,
	ecvendor_danfoss                            = 0x0300008d,
    ecvendor_parker_hannifin_ssd                = 0x04000089,
	ecvendor_longxin_zhijian                    = 0x04210909,
	ecvendor_meysar_makina                      = 0x04533417,
	ecvendor_all_lasersystem                    = 0x0505abcd,
	ecvendor_suzhou_gfd                         = 0x0512fdfd,
	ecvendor_l3_communications                  = 0x06402200,
	ecvendor_bnt                                = 0x06958326,
	ecvendor_japan_radio                        = 0x07770777,
    ecvendor_schneider_motion_control           = 0x0800005a,
	ecvendor_parker_hannifin                    = 0x08000089,
	ecvendor_parker_hannifin_corp               = 0x09000089,
	ecvendor_advanced_systems_dev               = 0x0a5d0000,
	ecvendor_dsp                                = 0x0adaffff,
	ecvendor_compac_sorting                     = 0x0c044bac,
	ecvendor_gsk                                = 0x0fff8888,
    ecvendor_fastech                            = 0x0fa00000,
	ecvendor_sonotronic                         = 0x10000000,
	ecvendor_xian_mosvo                         = 0x10000001,
    ecvendor_beckhoff_hardware                  = 0x10000002,
	ecvendor_ed                                 = 0x10000004,
	ecvendor_shanghai_sany_id1                  = 0x10000031,
	ecvendor_shanghai_sany_id2                  = 0x10000331,
	ecvendor_ga_drilling                        = 0x12345678,
	ecvendor_mettem                             = 0x17072003,
	ecvendor_tsinghua_uni_ee                    = 0x19491001,
	ecvendor_control_z                          = 0x19821130,
	ecvendor_shangha_damon                      = 0x19861230,
	ecvendor_iba                                = 0x1ba90762,
    ecvendor_hengstler                          = 0x20041961,
    ecvendor_lenord_bauer                       = 0x20422b4c,
	ecvendor_university_bremen                  = 0x20494154,
    ecvendor_ibv                                = 0x21494256,
	ecvendor_shanghai_cohere                    = 0x22222222,
	ecvendor_robert_bosch                       = 0x23091861,
	ecvendor_apdisar                            = 0x26262626,
	ecvendor_convex                             = 0x26376345,
	ecvendor_x2e                                = 0x2e000000,
	ecvendor_shanghai_sany_s                    = 0x30000331,
	ecvendor_sany_intelligent                   = 0x31313131,
	ecvendor_tu_darmstadt                       = 0x31393633,
	ecvendor_mkt_systemtechnik                  = 0x314d4b54,
	ecvendor_the_itaya                          = 0x33333333,
	ecvendor_korea_elec_institute               = 0x35409865,
	ecvendor_shanghai_sany_id3                  = 0x40000331,
    ecvendor_red_one                            = 0x40524f54,
	ecvendor_applied_materials                  = 0x414d4154,
	ecvendor_arca                               = 0x41524341,
	ecvendor_aval                               = 0x4156414c,
	ecvendor_trust                              = 0x42000000,
	ecvendor_central_south_university           = 0x43544c42,
	ecvendor_dek_printing                       = 0x44454b31,
	ecvendor_krebsforschungszentrum             = 0x444b465a,
	ecvendor_elovis                             = 0x454c4f56,
	ecvendor_ektech                             = 0x454d5245,
    ecvendor_shf_communication                  = 0x46485320,
	ecvendor_fms                                = 0x464d5331,
	ecvendor_marcus_gossner                     = 0x474f5353,
    ecvendor_grossenbacher                      = 0x47535953,
	ecvendor_hstar                              = 0x482a0000,
	ecvendor_university_western_swiss           = 0x48455673,
    ecvendor_nti_linmot                         = 0x4c4e5449,
	ecvendor_lam_research                       = 0x4c524358,
	ecvendor_mlt_micro                          = 0x4d4c5431,
    ecvendor_eltromat                           = 0x4c746c65,
	ecvendor_tu_braunschweig                    = 0x50005000,
	ecvendor_power_automation                   = 0x50414e43,
	ecvendor_rafi                               = 0x52414649,
	ecvendor_steinbeis                          = 0x53545a53,
	ecvendor_tecan                              = 0x5445434e,
	ecvendor_tews                               = 0x54455753,
	ecvendor_timax                              = 0x54494158,
	ecvendor_olympus                            = 0x55555555,
	ecvendor_siasun_robot                       = 0x5555aaaa,
	ecvendor_green_field                        = 0x55aa55aa,
	ecvendor_jt3                                = 0x55aa55bb,
	ecvendor_volvo                              = 0x56475454,
	ecvendor_megatec                            = 0x6167656d,
    ecvendor_arte_motion                        = 0x65547241,
    ecvendor_chinese_academy_ioe                = 0x66666666,
	ecvendor_shenzhen_just_motion               = 0x66668888,
    ecvendor_paul_maschinenfabrik               = 0x7061756c,
	ecvendor_mesacon                            = 0x77776968,
	ecvendor_shanghai_tech_full                 = 0x77778888,
	ecvendor_shandong_university                = 0x81696189,
	ecvendor_scandinova                         = 0x88888888,
	ecvendor_woojin_plaimm                      = 0x89898989,
	ecvendor_robocubetech                       = 0x90646350,
	ecvendor_shanghai_step                      = 0x99998888,
    ecvendor_sunin                              = 0xaaaa5555,
	ecvendor_comizoa                            = 0xaaaaaaaa,
	ecvendor_ruchservomotor                     = 0xaaaabbbb,
	ecvendor_dalian_jafeng                      = 0xaaaaffff,
	ecvendor_addi_data                          = 0xadd1da7a,
	ecvendor_husky_injection                    = 0xb0500001,
	ecvendor_jinoid                             = 0xbcda0001,
	ecvendor_bertec                             = 0xbe78ec01,
	ecvendor_innovasic                          = 0xc0decafe,
	ecvendor_puloonc                            = 0xd4c3b2a1,
    ecvendor_handtmann                          = 0xdeadbeef,
	ecvendor_dewesoft                           = 0xdebe50f7,

    /* Borland C++ datatype alignment correction */
    ecvendor_BCppDummy                          = 0xFFFFFFFF
} T_eEtherCAT_Vendor;

typedef enum _T_eEtherCAT_ProductCode
{
    /* Beckhoff Automation */
    ecprodcode_beck_AX2000_B110                 = 0x07D06014,
    ecprodcode_beck_AX2000_B120                 = 0x07D06014,
    ecprodcode_beck_BK1120                      = 0x04602C22,
    ecprodcode_beck_CX1100_0004                 = 0x044C6032,
    ecprodcode_beck_CU1128                      = 0x04685432,
    ecprodcode_beck_EK1100                      = 0x044C2C52,
    ecprodcode_beck_EK1101                      = 0x044D2C52,
    ecprodcode_beck_EK1122                      = 0x04622C52,
    ecprodcode_beck_EK1814                      = 0x07162C52,
    ecprodcode_beck_EK1818                      = 0x071A2C52,
    ecprodcode_beck_EK1828                      = 0x07242C52,
    ecprodcode_beck_EK1914                      = 0x077A2C52,
    ecprodcode_beck_EL1002                      = 0x03EA3052,
    ecprodcode_beck_EL1004                      = 0x03EC3052,
    ecprodcode_beck_EL1004_0010                 = 0x03EC3052,
    ecprodcode_beck_EL1008                      = 0x03F03052,
    ecprodcode_beck_EL1012                      = 0x03F43052,
    ecprodcode_beck_EL1014                      = 0x03F63052,
    ecprodcode_beck_EL1014_0010                 = 0x03F63052,
    ecprodcode_beck_EL1018                      = 0x03FA3052,
    ecprodcode_beck_EL1034                      = 0x040A3052,
    ecprodcode_beck_EL1094                      = 0x04463052,
    ecprodcode_beck_EL1114                      = 0x045A3052,
    ecprodcode_beck_EL1259                      = 0x04EB3052,
    ecprodcode_beck_EL1262                      = 0x04EE3052,
    ecprodcode_beck_EL1889                      = 0x07613052,
    ecprodcode_beck_EL1904                      = 0x07703052,
    ecprodcode_beck_EL2002                      = 0x07D23052,
    ecprodcode_beck_EL2004                      = 0x07D43052,
    ecprodcode_beck_EL2008                      = 0x07D83052,
    ecprodcode_beck_EL2032                      = 0x07F03052,
    ecprodcode_beck_EL2262                      = 0x08D63052,
    ecprodcode_beck_EL2502                      = 0x09C63052,
    ecprodcode_beck_EL2521                      = 0x09D93052,
    ecprodcode_beck_EL2521_1001                 = 0x09D93052,
    ecprodcode_beck_EL2809                      = 0x0AF93052,
    ecprodcode_beck_EL2889                      = 0x0B493052,
    ecprodcode_beck_EL2904                      = 0x0B583052,
    ecprodcode_beck_EL3064                      = 0x0BF83052,
    ecprodcode_beck_EL3102                      = 0x0C1E3052,
    ecprodcode_beck_EL3112                      = 0x0C283052,
    ecprodcode_beck_EL3122                      = 0x0C323052,
    ecprodcode_beck_EL3142                      = 0x0C463052,
    ecprodcode_beck_EL3142_0010                 = 0x0C463052,
    ecprodcode_beck_EL3152                      = 0x0C503052,
    ecprodcode_beck_EL3162                      = 0x0C5A3052,
    ecprodcode_beck_EL3202                      = 0x0C823052,
    ecprodcode_beck_EL3255                      = 0x0CB73052,
    ecprodcode_beck_EL3312                      = 0x0CF03052,
    ecprodcode_beck_EL3356                      = 0x0D1C3052,
    ecprodcode_beck_EL3702                      = 0x0E763052,
    ecprodcode_beck_EL4002                      = 0x0FA23052,
    ecprodcode_beck_EL4004                      = 0x0FA43052,
    ecprodcode_beck_EL4102                      = 0x10063052,
    ecprodcode_beck_EL4112                      = 0x10103052,
    ecprodcode_beck_EL4112_0010                 = 0x10103052,
    ecprodcode_beck_EL4122                      = 0x101A3052,
    ecprodcode_beck_EL4132                      = 0x10243052,
    ecprodcode_beck_EL5001                      = 0x13893052,
    ecprodcode_beck_EL5101                      = 0x13ED3052,
    ecprodcode_beck_EL5151                      = 0x141F3052,
    ecprodcode_beck_EL5152                      = 0x14203052,
    ecprodcode_beck_AX5206                      = 0x14566012,
    ecprodcode_beck_EL6001                      = 0x17713052,
    ecprodcode_beck_EL6021                      = 0x17853052,
    ecprodcode_beck_EL6601                      = 0x19C93052,
    ecprodcode_beck_EL6614                      = 0x19D63052,
    ecprodcode_beck_EL6690                      = 0x1A223052,
    ecprodcode_beck_EL6692                      = 0x1A243052,
    ecprodcode_beck_EL6731                      = 0x1A4B3052,
    ecprodcode_beck_EL6731_0010                 = 0x1A4B3052,
    ecprodcode_beck_EL6751                      = 0x1A5F3052,
    ecprodcode_beck_EL6752                      = 0x1A603052,
    ecprodcode_beck_EL6900                      = 0x1AF43052,
    ecprodcode_beck_EL6910                      = 0x1AFE3052,
    ecprodcode_beck_EL6930                      = 0x1B123052,
    ecprodcode_beck_EL9505                      = 0x25213052,
    ecprodcode_beck_EL9510                      = 0x25263052,
    ecprodcode_beck_EL9512                      = 0x25283052,
    ecprodcode_beck_EL9800                      = 0x26483052,
    ecprodcode_beck_FM5001                      = 0x13893462,
    ecprodcode_beck_EK1110                      = 0x04562C52,
    ecprodcode_beck_EL2252                      = 0x08CC3052,
    ecprodcode_beck_EL1252                      = 0x04E43052,
    ecprodcode_beck_EL9820                      = 0x04570862,

    /* Ixxat */
    ecprodcode_ixx_iem                          = 0x00000001,
    ecprodcode_ixx_ETCio100                     = 0x00000006,

    /* ESR Pollmeier */
    ecprodcode_esr_Trio                         = 0x00001A63,
    ecprodcode_esr_Midi                         = 0x00001A59,
    ecprodcode_esr_Trio_1                       = 0x67550000,    /* may not work, ESR faulty Device Desc XML? */

    /* KUEBLER */
    ecprodcode_kuebler_Multiturn5868            = 0x5868B111,

    /* KEB */
    ecprodcode_keb_KEB1736F5_3d                 = 0x000006C8,
    ecprodcode_keb_EcatGateway                  = 0x00002201,

    /* MOOG */
    ecprodcode_moog_anin                        = 0x00000001,
    ecprodcode_moog_ServoValveD671              = 0x000000D5,

    /* Lenze */
    ecprodcode_ldc_el9400                       = 0x00000001,
    ecprodcode_ldc_e94aycet                     = 0x00000002,
    ecprodcode_ldc_servogun2                    = 0x00000052,
    ecprodcode_ldc_servogun3                    = 0x00000053,
    ecprodcode_ldc_epms130                      = 0x00000514,
    ecprodcode_ldc_el8400                       = 0x000CD156,
    ecprodcode_ldc_stateline                    = 0x02010000,
    ecprodcode_ldc_highlineCIA402               = 0x38079D3D,

    /* Hilscher */
    ecprodcode_hil_NXSB100                      = 0x00000005,
    ecprodcode_hil_NXSB100DC                    = 0x7874656E,

    /* Renesas */
    ecprodcode_ren_EC1                          = 0x00000501,

    /* Schmidhauser */
    ecprodcode_sh_ACSE                          = 0x000000E0,

    /* SEW EuroDrive */
    ecprodcode_sew_movidrive                    = 0x00000001,
    ecprodcode_sew_moviaxis                     = 0x00000003,

    /* Danaher */
    ecprodcode_dan_servostar300                 = 0x00000000,

    /* Control Techniques */
    ecprodcode_ct_drive                         = 0x000001A5,
    ecprodcode_ct_drive_sp                      = 0x00030003,

    /* SMC */
    ecprodcode_smc_serifcunit                   = 0x22C53452,

    /* JUMO-Module */
    ecprodcode_jumo_Basis                       = 0x01010101,
    ecprodcode_jumo_Busskoppler                 = 0x02020202,
    ecprodcode_jumo_HMI                         = 0x03030303,
    ecprodcode_jumo_Router                      = 0x01234567,
    ecprodcode_jumo_BIO                         = 0x17214990,
    ecprodcode_jumo_RELAIS                      = 0x02345678,
    ecprodcode_jumo_REGLER                      = 0x26483053,
    ecprodcode_jumo_Analog_4_Ein                = 0x11111111,
    ecprodcode_jumo_Analog_8_Ein                = 0x22222222,
    ecprodcode_jumo_Analog_4_Aus                = 0x33333333,
    ecprodcode_jumo_Analog_8_Aus                = 0x44444444,

    /* BAUMUELLER */
    ecprodcode_baumueller_BM4000                = 0x00002775,
    ecprodcode_baumueller_BM3000                = 0x03010001,
    ecprodcode_baumueller_BM5000                = 0x05010100,

    /* Deutschmann */
    ecprodcode_dm_rs232gw                       = 0x26483052,

    /* Parker */
    ecprodcode_par_drive                        = 0x002E3BF1,

    /* National Instruments */
    ecprodcode_ni_digio                         = 0x0000000A,
    ecprodcode_ni_anaio                         = 0x000023B8,

    /* IDAM */
    ecprodcode_idam_DSMRW                       = 0x00000002,

    /* Infineon Technologies */
    ecprodcode_XMC4800Relax                     = 0x00008000,

    /* TR */
    ecprodcode_tr_linencoder2                   = 0x04D2AB01,

    /* BCE */
    ecprodcode_bce_AMAT_Handbox                 = 0x00000010,
    ecprodcode_bce_AMAT_HB_digout               = 0x00000020,
    ecprodcode_bce_AMAT_HB_digin                = 0x00000030,

    /* Koenig */
    ecprodcode_kng_pc104                        = 0x02628175,

    /* acontis */
    ecprodcode_at_atem                          = 0x6D657461,
    ecprodcode_at_atemTestSlave                 = 0xE0000001,


    /* KUKA */
    ecprodcode_kr_cib                           = 0x00000001,
    ecprodcode_kr_rdc3                          = 0x00000030,
    ecprodcode_kr_cibsion                       = 0x00000101,
    ecprodcode_kr_sionkpp                       = 0x00000110,
    ecprodcode_kr_sionksp                       = 0x00000111,

    /* Kuhnke */
    ecprodcode_kuh_VFIO_BK                      = 0x000248EC,
    ecprodcode_kuh_VFIO_DIO                     = 0x000248ED,
    ecprodcode_kuh_VFIO_DIO16                   = 0x00024AB8,
    /* JAT */
    ecprodcode_jat_drive1                       = 0x00000001,

    /* Festo */
    ecprodcode_fst_cpx                          = 0x00000026,

    /* Copley */
    ecprodcode_cpl_accelnet                     = 0x00000380,

    /* Robox */
    ecprodcode_rx_coedrivegw                    = 0x00000034,

    /* dresden elektronik */
    ecprodcode_de_sdac3100                      = 0x00000287,

    /* yaskawa */
    ecprodcode_yas_sgdv_e1                      = 0x02200001,

    /* metronix */
    ecprodcode_metronix_ARS2000                 = 0x264860D3,

    /* vipa */
    ecprodcode_vipa_coupler_053                 = 0x0531EC00,

    /* omron */
    ecprodcode_omron_GX_ID1621                  = 0x00000017,
    ecprodcode_omron_GX_OD1621                  = 0x00000029,
    ecprodcode_omron_GX_JC06_Main               = 0x00000064,
    ecprodcode_omron_GX_JC06_Sub                = 0x00000065,
    ecprodcode_omron_GX_JC06H_Main              = 0x00000081,
    ecprodcode_omron_GX_JC06H_Sub               = 0x00000082,

    /* Borland C++ datatype alignment correction */
    ecprodcode_BCppDummy                        = 0xFFFFFFFF
} T_eEtherCAT_ProductCode;

/*-DEFINES-------------------------------------------------------------------*/
#define IGNORE_SERIAL ((EC_T_DWORD)(-1))

EC_T_BOOL PrintSlaveInfos(T_EC_DEMO_APP_CONTEXT* pAppContext);
EC_T_VOID PrintCfgSlavesInfo(T_EC_DEMO_APP_CONTEXT* pAppContext);
EC_T_VOID PrintBusSlavesInfo(T_EC_DEMO_APP_CONTEXT* pAppContext);
EC_T_BOOL PrintAllSlavesProcVarInfos(T_EC_DEMO_APP_CONTEXT* pAppContext);

EC_T_BOOL FindSlaveGetFixedAddr(
    T_EC_DEMO_APP_CONTEXT* pAppContext,
    EC_T_DWORD             dwSlaveInstance,       /**< [in]   Slave instance (0 = first matching, 1 = second, ...) */
    EC_T_DWORD             dwVendorId,            /**< [in]   Vendor Id of slave to search */
    EC_T_DWORD             dwProductCode,         /**< [in]   Product Code of slave to search */
    EC_T_WORD*             pwStationAddr          /**< [out]  Station address of slave */
);
EC_T_BOOL FindCfgSlaveGetFixedAddr(
    T_EC_DEMO_APP_CONTEXT* pAppContext,
    EC_T_DWORD             dwSlaveInstance,       /**< [in]   Slave instance (0 = first matching, 1 = second, ...) */
    EC_T_DWORD             dwVendorId,            /**< [in]   Vendor Id of slave to search */
    EC_T_DWORD             dwProductCode,         /**< [in]   Product Code of slave to search */
    EC_T_WORD*             pwStationAddr          /**< [out]  Station address of slave */
);

const EC_T_CHAR* SlaveVendorText(T_eEtherCAT_Vendor eVendorId);
const EC_T_CHAR* SlaveProdCodeText(T_eEtherCAT_Vendor eVendorId, T_eEtherCAT_ProductCode eProductCode);
const EC_T_CHAR* ESCTypeText(EC_T_BYTE byESCType);
const EC_T_CHAR* DataTypeText(EC_T_WORD wDataType);

#endif /* INC_ECSLAVEINFO */

/*-END OF SOURCE FILE--------------------------------------------------------*/
